/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mrbysco.distantfriends.CommonClass;
import com.mrbysco.distantfriends.commands.DistantCommands;
import com.mrbysco.distantfriends.config.FriendConfigNeoForge;
import com.mrbysco.distantfriends.util.FriendSpawner;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="distantfriends")
public class DistantFriendsNeoForge {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"distantfriends");
    public static final Supplier<AttachmentType<Boolean>> IS_FRIEND = ATTACHMENT_TYPES.register("is_friend", () -> AttachmentType.builder(() -> false).serialize(Codec.BOOL.fieldOf("is_friend")).build());

    public DistantFriendsNeoForge(IEventBus eventBus, ModContainer container, Dist dist) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FriendConfigNeoForge.commonSpec);
        eventBus.register(FriendConfigNeoForge.class);
        ATTACHMENT_TYPES.register(eventBus);
        NeoForge.EVENT_BUS.addListener(this::onFriendDamage);
        NeoForge.EVENT_BUS.addListener(this::onFriendTick);
        NeoForge.EVENT_BUS.addListener(this::onLevelLoad);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void onFriendDamage(LivingIncomingDamageEvent event) {
        Mannequin mannequin;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mannequin && (mannequin = (Mannequin)livingEntity).hasData(IS_FRIEND)) {
            CommonClass.onFriendDamage(mannequin);
        }
    }

    private void onFriendTick(EntityTickEvent.Pre event) {
        Mannequin mannequin;
        Entity entity = event.getEntity();
        if (entity instanceof Mannequin && (mannequin = (Mannequin)entity).hasData(IS_FRIEND)) {
            CommonClass.onFriendTick(mannequin);
        }
    }

    private void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            level.customSpawners = ImmutableList.builder().addAll((Iterable)level.customSpawners).add((Object)new FriendSpawner()).build();
        }
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        DistantCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

