/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mrbysco.distantfriends.CommonClass;
import com.mrbysco.distantfriends.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DistantCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"distantfriends");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"spawnFriend").executes(commandContext -> DistantCommands.spawnFriend((CommandContext<CommandSourceStack>)commandContext, ((CommandSourceStack)commandContext.getSource()).getPosition()))).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> DistantCommands.spawnFriend((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos")))));
        dispatcher.register(root);
    }

    private static int spawnFriend(CommandContext<CommandSourceStack> context, Vec3 position) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = BlockPos.containing((Position)position);
        Mannequin friend = (Mannequin)EntityType.MANNEQUIN.create((Level)level, EntitySpawnReason.COMMAND);
        if (friend != null) {
            friend.snapTo(pos, 0.0f, 0.0f);
            Services.PLATFORM.attachFriendData(friend);
            CommonClass.attachSkin(friend);
            level.addFreshEntityWithPassengers((Entity)friend);
            return 0;
        }
        return 1;
    }
}

