/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.config;

import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.util.FriendNamesCache;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FriendConfigNeoForge {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Distant Friends' config file {}", (Object)configEvent.getConfig().getFileName());
        FriendNamesCache.refreshCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.debug("Distant Friends' config just got changed on the file system!");
        FriendNamesCache.refreshCache();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<List<? extends String>> friends;
        public final ModConfigSpec.ConfigValue<List<? extends String>> spawnDimensions;
        public final ModConfigSpec.BooleanValue addWhitelistPlayers;
        public final ModConfigSpec.BooleanValue showName;
        public final ModConfigSpec.BooleanValue playerMobsCompat;
        public final ModConfigSpec.ConfigValue<List<? extends String>> playerMobsNameLinks;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Friends").push("friend_settings");
            this.friends = builder.comment(new String[]{"A list of users who can be chosen when it spawns a distant friend. ", "Format: \"<username>\", \"<username>,<texture_location/body_type>\" or \"<username>,<texture_location/body_type>,<body_type>\"", "Example: \"darkosto\" or \"darkosto,minecraft:entity/player/slim/noor,slim\""}).defineListAllowEmpty("friends", List.of("darkosto", "shynieke", "mrbysco"), String::new, o -> o instanceof String);
            this.spawnDimensions = builder.comment(new String[]{"A list of dimensions where distant friends can spawn, using their resource location. ", "Format: \"<namespace>:<path>\"", "Example: \"minecraft:overworld\" or \"minecraft:the_nether\""}).defineListAllowEmpty("spawnDimensions", List.of("minecraft:overworld"), String::new, o -> o instanceof String && ResourceLocation.tryParse((String)((String)o)) != null);
            this.addWhitelistPlayers = builder.comment("Add the players from the whitelist to the Friends list [default: true]").define("addWhitelistPlayers", true);
            this.showName = builder.comment("Show the name of the friend above their head [default: true]").define("showName", true);
            builder.pop();
            builder.comment("Compat").push("compat_settings");
            this.playerMobsCompat = builder.comment("Add players from a Player Mobs whitelist to the Friends list [default: false]").define("playerMobsCompat", false);
            this.playerMobsNameLinks = builder.comment("The player mobs Name Links, must start with https://whitelist.gorymoon.se").defineListAllowEmpty("playerMobsNameLinks", List.of(), String::new, o -> {
                String string;
                return o instanceof String && (string = (String)o).startsWith("https://whitelist.gorymoon.se");
            });
            builder.pop();
        }
    }
}

