/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.data;

import com.mrbysco.distantfriends.Constants;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DistantDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new Datapack(packOutput, lookupProvider, Set.of("distantfriends")));
        generator.addProvider(true, (DataProvider)new Language(packOutput));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Constants.modLoc(name));
    }

    private static class Datapack
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
            BiomeModifiers.AddSpawnsBiomeModifier addSpawn = BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeHolderGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(EntityType.MANNEQUIN, 1, 2), 20));
            context.register(DistantDatagen.createKey("add_distant_friend"), (Object)addSpawn);
        });

        public Datapack(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
            super(output, registries, BUILDER, modIds);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "distantfriends", "en_us");
        }

        protected void addTranslations() {
            this.addConfig("title", "Distant Friends Config", null);
            this.addConfig("friend_settings", "Friends", "Friend Settings");
            this.addConfig("friends", "Friends", "A list of users who can be chosen when it spawns a distant friend");
            this.addConfig("spawnDimensions", "Friends", "A list of dimensions where distant friends can spawn, using their resource location");
            this.addConfig("addWhitelistPlayers", "Add Whitelist Players", "Add the players from the whitelist to the Friends list [default: true]");
            this.addConfig("showName", "Show Name", "Show the name of the friend above their head");
            this.addConfig("compat_settings", "Compat", "Compat Settings");
            this.addConfig("playerMobsCompat", "Player Mobs Compat", "Add players from a Player Mobs whitelist to the Friends list [default: false]");
            this.addConfig("playerMobsNameLinks", "Player Mobs Name Links", "The player mobs Name Links");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("distantfriends.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("distantfriends.configuration." + path + ".tooltip", description);
            }
        }
    }
}

