/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.util;

import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.platform.Services;
import com.mrbysco.distantfriends.util.PlayerData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.world.entity.player.PlayerModelType;

public class FriendNamesCache {
    public static final List<PlayerData> nameList = new ArrayList<PlayerData>();

    public static void refreshCache() {
        Constants.LOGGER.info("Refreshing friends cache");
        nameList.clear();
        nameList.addAll(FriendNamesCache.generateDataList());
        if (Services.PLATFORM.addWhitelistPlayers() && Services.PLATFORM.getServer() != null) {
            UserWhiteList whitelist = Services.PLATFORM.getServer().getPlayerList().getWhiteList();
            Arrays.stream(whitelist.getUserList()).map(PlayerData::new).forEach(nameList::add);
        }
        if (Services.PLATFORM.playerMobsCompat()) {
            List<? extends String> links = Services.PLATFORM.getPlayerMobsNameLinks();
            for (String string : links) {
                try {
                    URL url = new URL(string);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            nameList.add(new PlayerData(line));
                        }
                    }
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Error fetching names from {}", (Object)string, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<PlayerData> generateDataList() {
        ArrayList<PlayerData> dataList = new ArrayList<PlayerData>();
        ArrayList<? extends String> names = new ArrayList<String>(Services.PLATFORM.getFriends());
        for (String string : names) {
            void var3_3;
            if (string.isEmpty()) continue;
            String[] parts = string.split(",");
            String secondEntry = null;
            PlayerModelType bodyType = null;
            if (parts.length > 1) {
                String string2 = parts[0].trim();
                secondEntry = parts[1].trim();
                if (secondEntry.equals("slim") || secondEntry.equals("wide")) {
                    bodyType = secondEntry.equals("slim") ? PlayerModelType.SLIM : PlayerModelType.WIDE;
                    secondEntry = "";
                } else if (parts.length > 2) {
                    String type = parts[2].trim().toLowerCase();
                    if (type.equals("slim")) {
                        bodyType = PlayerModelType.SLIM;
                    } else if (type.equals("wide")) {
                        bodyType = PlayerModelType.WIDE;
                    }
                }
                if (!secondEntry.isEmpty() && ResourceLocation.tryParse((String)secondEntry) == null) {
                    Constants.LOGGER.error("Malformed ResourceLocation for friend: {}, {}", (Object)string2, (Object)secondEntry);
                    secondEntry = null;
                }
            }
            dataList.add(new PlayerData((String)var3_3, secondEntry, bodyType));
        }
        return dataList;
    }
}

