/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.util;

import com.mrbysco.distantfriends.CommonClass;
import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class FriendSpawner
implements CustomSpawner {
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 5;
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    public void tick(ServerLevel level, boolean spawnEnemies) {
        --this.nextTick;
        if (this.nextTick <= 0) {
            this.nextTick = 1200;
            ServerPlayer player = level.getRandomPlayer();
            if (player != null && Services.PLATFORM.isDimensionAllowed(level.dimension().location())) {
                RandomSource randomsource = level.random;
                BlockPos playerPos = player.blockPosition();
                for (int attempt = 0; attempt < 5; ++attempt) {
                    int z;
                    int y;
                    int x = playerPos.getX() + randomsource.nextInt(96) - 48;
                    BlockPos blockpos = new BlockPos(x, y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = playerPos.getZ() + randomsource.nextInt(96) - 48), z);
                    if (!SpawnPlacementTypes.ON_GROUND.isSpawnPositionOk((LevelReader)level, blockpos, EntityType.MANNEQUIN) || !this.noneNearby(level, blockpos) || !this.isDarkEnoughToSpawn((ServerLevelAccessor)level, blockpos, randomsource)) continue;
                    this.spawnFriend(blockpos, level);
                }
            }
        }
    }

    private boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        if (levelAccessor.getBrightness(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.getLevel().isThundering() ? levelAccessor.getMaxLocalRawBrightness(pos, 10) : levelAccessor.getMaxLocalRawBrightness(pos);
        return i <= random.nextInt(8);
    }

    private boolean noneNearby(ServerLevel level, BlockPos pos) {
        return Services.PLATFORM.getNearbyFriends(level, pos, 64, 8).isEmpty();
    }

    private void spawnFriend(BlockPos pos, ServerLevel level) {
        if (!level.isLoaded(pos)) {
            return;
        }
        Mannequin friend = (Mannequin)EntityType.MANNEQUIN.create((Level)level, EntitySpawnReason.NATURAL);
        if (friend != null) {
            friend.snapTo(pos, 0.0f, 0.0f);
            Services.PLATFORM.attachFriendData(friend);
            Constants.LOGGER.info("{}", (Object)("Spawning a Distant Friend at " + String.valueOf(pos)));
            CommonClass.attachSkin(friend);
            level.addFreshEntityWithPassengers((Entity)friend);
        }
    }
}

