/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.datagen.providers;

import com.autovw.advancednetherite.core.ModBlocks;
import com.autovw.advancednetherite.core.ModItems;
import com.autovw.advancednetherite.core.util.ModEquipmentAssets;
import java.util.Collections;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput, modId);
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.blockModel(blockModels, ModBlocks.NETHERITE_IRON_BLOCK);
        this.blockModel(blockModels, ModBlocks.NETHERITE_GOLD_BLOCK);
        this.blockModel(blockModels, ModBlocks.NETHERITE_EMERALD_BLOCK);
        this.blockModel(blockModels, ModBlocks.NETHERITE_DIAMOND_BLOCK);
        this.itemModel(itemModels, ModItems.NETHERITE_IRON_INGOT);
        this.itemModel(itemModels, ModItems.NETHERITE_GOLD_INGOT);
        this.itemModel(itemModels, ModItems.NETHERITE_EMERALD_INGOT);
        this.itemModel(itemModels, ModItems.NETHERITE_DIAMOND_INGOT);
        this.armorModel(itemModels, ModItems.NETHERITE_IRON_HELMET, ModEquipmentAssets.NETHERITE_IRON);
        this.armorModel(itemModels, ModItems.NETHERITE_IRON_CHESTPLATE, ModEquipmentAssets.NETHERITE_IRON);
        this.armorModel(itemModels, ModItems.NETHERITE_IRON_LEGGINGS, ModEquipmentAssets.NETHERITE_IRON);
        this.armorModel(itemModels, ModItems.NETHERITE_IRON_BOOTS, ModEquipmentAssets.NETHERITE_IRON);
        this.armorModel(itemModels, ModItems.NETHERITE_GOLD_HELMET, ModEquipmentAssets.NETHERITE_GOLD);
        this.armorModel(itemModels, ModItems.NETHERITE_GOLD_CHESTPLATE, ModEquipmentAssets.NETHERITE_GOLD);
        this.armorModel(itemModels, ModItems.NETHERITE_GOLD_LEGGINGS, ModEquipmentAssets.NETHERITE_GOLD);
        this.armorModel(itemModels, ModItems.NETHERITE_GOLD_BOOTS, ModEquipmentAssets.NETHERITE_GOLD);
        this.armorModel(itemModels, ModItems.NETHERITE_EMERALD_HELMET, ModEquipmentAssets.NETHERITE_EMERALD);
        this.armorModel(itemModels, ModItems.NETHERITE_EMERALD_CHESTPLATE, ModEquipmentAssets.NETHERITE_EMERALD);
        this.armorModel(itemModels, ModItems.NETHERITE_EMERALD_LEGGINGS, ModEquipmentAssets.NETHERITE_EMERALD);
        this.armorModel(itemModels, ModItems.NETHERITE_EMERALD_BOOTS, ModEquipmentAssets.NETHERITE_EMERALD);
        this.armorModel(itemModels, ModItems.NETHERITE_DIAMOND_HELMET, ModEquipmentAssets.NETHERITE_DIAMOND);
        this.armorModel(itemModels, ModItems.NETHERITE_DIAMOND_CHESTPLATE, ModEquipmentAssets.NETHERITE_DIAMOND);
        this.armorModel(itemModels, ModItems.NETHERITE_DIAMOND_LEGGINGS, ModEquipmentAssets.NETHERITE_DIAMOND);
        this.armorModel(itemModels, ModItems.NETHERITE_DIAMOND_BOOTS, ModEquipmentAssets.NETHERITE_DIAMOND);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_IRON_AXE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_GOLD_AXE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_EMERALD_AXE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_DIAMOND_AXE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_IRON_HOE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_GOLD_HOE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_EMERALD_HOE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_DIAMOND_HOE);
        this.toolModel(itemModels, ModItems.NETHERITE_IRON_PICKAXE);
        this.toolModel(itemModels, ModItems.NETHERITE_GOLD_PICKAXE);
        this.toolModel(itemModels, ModItems.NETHERITE_EMERALD_PICKAXE);
        this.toolModel(itemModels, ModItems.NETHERITE_DIAMOND_PICKAXE);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_IRON_SHOVEL);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_GOLD_SHOVEL);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_EMERALD_SHOVEL);
        this.toolModel(itemModels, (Item)ModItems.NETHERITE_DIAMOND_SHOVEL);
        this.toolModel(itemModels, ModItems.NETHERITE_IRON_SWORD);
        this.toolModel(itemModels, ModItems.NETHERITE_GOLD_SWORD);
        this.toolModel(itemModels, ModItems.NETHERITE_EMERALD_SWORD);
        this.toolModel(itemModels, ModItems.NETHERITE_DIAMOND_SWORD);
    }

    public void blockModel(BlockModelGenerators blockModels, Block block) {
        blockModels.createTrivialCube(block);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_ITEM);
    }

    public void toolModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }

    public void armorModel(ItemModelGenerators itemModels, Item item, ResourceKey<EquipmentAsset> equipmentKey) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation armorType = null;
        if (id.getPath().contains("helmet")) {
            armorType = ItemModelGenerators.TRIM_PREFIX_HELMET;
        } else if (id.getPath().contains("chestplate")) {
            armorType = ItemModelGenerators.TRIM_PREFIX_CHESTPLATE;
        } else if (id.getPath().contains("leggings")) {
            armorType = ItemModelGenerators.TRIM_PREFIX_LEGGINGS;
        } else if (id.getPath().contains("boots")) {
            armorType = ItemModelGenerators.TRIM_PREFIX_BOOTS;
        }
        itemModels.generateTrimmableItem(item, equipmentKey, armorType, false);
    }
}

