/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common;

import com.autovw.advancednetherite.api.impl.IAdvancedHooks;
import com.autovw.advancednetherite.api.impl.IArmorMaterial;
import com.autovw.advancednetherite.api.impl.IToolMaterial;
import com.autovw.advancednetherite.common.item.AdvancedArmorItem;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModArmorMaterials;
import com.autovw.advancednetherite.core.util.ModToolMaterials;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedUtil {
    public static int getArmorDurabilityMultiplier(ArmorMaterial material) {
        if (material == ModArmorMaterials.NETHERITE_IRON) {
            return 39;
        }
        if (material == ModArmorMaterials.NETHERITE_GOLD) {
            return 41;
        }
        if (material == ModArmorMaterials.NETHERITE_EMERALD) {
            return 43;
        }
        if (material == ModArmorMaterials.NETHERITE_DIAMOND) {
            return 47;
        }
        return 0;
    }

    public static int getDurabilityBarColor(int originalColor, ItemStack stack) {
        int newColor = originalColor;
        if (ConfigHelper.get().getClient().matchingDurabilityBars()) {
            Object material;
            Item item = stack.getItem();
            if (item instanceof IToolMaterial) {
                material = (IToolMaterial)item;
                if (material.isMaterial(ModToolMaterials.NETHERITE_IRON)) {
                    newColor = ChatFormatting.GRAY.getColor();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_GOLD)) {
                    newColor = ChatFormatting.GOLD.getColor();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_EMERALD)) {
                    newColor = ChatFormatting.DARK_GREEN.getColor();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_DIAMOND)) {
                    newColor = ChatFormatting.AQUA.getColor();
                }
            }
            if ((item = stack.getItem()) instanceof IArmorMaterial) {
                material = (IArmorMaterial)item;
                if (material.isMaterial(ModArmorMaterials.NETHERITE_IRON)) {
                    newColor = ChatFormatting.GRAY.getColor();
                }
                if (material.isMaterial(ModArmorMaterials.NETHERITE_GOLD)) {
                    newColor = ChatFormatting.GOLD.getColor();
                }
                if (material.isMaterial(ModArmorMaterials.NETHERITE_EMERALD)) {
                    newColor = ChatFormatting.DARK_GREEN.getColor();
                }
                if (material.isMaterial(ModArmorMaterials.NETHERITE_DIAMOND)) {
                    newColor = ChatFormatting.AQUA.getColor();
                }
            }
        }
        return newColor;
    }

    public static float getDestroySpeed(float originalSpeed, ItemStack stack, BlockState state) {
        float newSpeed = originalSpeed;
        Item item = stack.getItem();
        if (item instanceof IToolMaterial) {
            IToolMaterial material = (IToolMaterial)item;
            if (stack.getItem().isCorrectToolForDrops(stack, state)) {
                if (material.isMaterial(ModToolMaterials.NETHERITE_IRON)) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getIronBreakingSpeedMultiplier();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_GOLD)) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getGoldBreakingSpeedMultiplier();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_EMERALD)) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getEmeraldBreakingSpeedMultiplier();
                }
                if (material.isMaterial(ModToolMaterials.NETHERITE_DIAMOND)) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getDiamondBreakingSpeedMultiplier();
                }
            }
        }
        return newSpeed;
    }

    public static boolean isWearingEndermanPassiveArmor(Player player) {
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            ItemStack stack = player.getItemBySlot(slot);
            Item item = stack.getItem();
            if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesEndermen(stack)) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyEndermen(stack))) continue;
            return true;
        }
        return false;
    }

    public static boolean isWearingPhantomPassiveArmor(Player player) {
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            ItemStack stack = player.getItemBySlot(slot);
            Item item = stack.getItem();
            if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesPhantoms(stack)) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyPhantoms(stack))) continue;
            return true;
        }
        return false;
    }
}

