/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.client.render;

import com.cozary.ore_creeper.client.model.OreCreeperModel;
import com.cozary.ore_creeper.entities.NetherGoldCreeperEntity;
import com.cozary.ore_creeper.util.ClientEventBusSubscriber;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class NetherGoldCreeperRenderer
extends MobRenderer<NetherGoldCreeperEntity, OreCreeperModel<NetherGoldCreeperEntity>> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ore_creeper", (String)"textures/entity/nether_gold_creeper.png");
    ResourceLocation entityIconLoc = ResourceLocation.fromNamespaceAndPath((String)"ore_creeper", (String)"ore_creeper".replace("/entity/", "/entity_icon/"));

    public NetherGoldCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, new OreCreeperModel(context.bakeLayer(ClientEventBusSubscriber.NETHER_GOLD_CREEPER)), 0.5f);
    }

    protected void scale(NetherGoldCreeperEntity p_114046_, PoseStack p_114047_, float p_114048_) {
        float f = p_114046_.getSwelling(p_114048_);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(NetherGoldCreeperEntity p_114043_, float p_114044_) {
        float f = p_114043_.getSwelling(p_114044_);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull NetherGoldCreeperEntity p_114041_) {
        return TEXTURE;
    }

    @NotNull
    public ResourceLocation getEntityIconLoc(@NotNull NetherGoldCreeperEntity p_114041_) {
        return this.entityIconLoc;
    }
}

