/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.config;

import com.cozary.ore_creeper.config.CommonConfig;
import com.cozary.ore_creeper.util.ConfigUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class CommonConfigManager {
    private static final Path CONFIG_PATH = Path.of("config", "ore-creeper-common.json");
    private static CommonConfig config = new CommonConfig();

    public static void loadConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            CommonConfig read = (CommonConfig)ConfigUtils.readConfig(CONFIG_PATH, CommonConfig.class);
            if (read != null) {
                config = read;
            } else {
                CommonConfigManager.saveConfig();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load general config.");
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            ConfigUtils.writeConfig(CONFIG_PATH, config);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save general config", e);
        }
    }

    public static CommonConfig getConfig() {
        return config;
    }
}

