/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.entities;

import com.cozary.ore_creeper.config.CommonConfigManager;
import com.cozary.ore_creeper.entities.AbstractOreCreeperEntity;
import com.cozary.ore_creeper.init.ModTags;
import com.cozary.ore_creeper.init.ParticleList;
import com.cozary.ore_creeper.util.ExplosionTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class NetherGoldCreeperEntity
extends AbstractOreCreeperEntity {
    public NetherGoldCreeperEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static boolean canOreCreeperSpawn(EntityType<? extends AbstractOreCreeperEntity> creeper, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return (float)pos.getY() < CommonConfigManager.getConfig().netherGoldCreeperMaxSpawnYLevel() && world.getBlockState(pos.below()).is(ModTags.SPAWNABLE_BLOCKS_NETHER);
    }

    public void explodeCreeper() {
        double d0 = this.random.nextGaussian() * 0.02;
        double d1 = this.random.nextGaussian() * 0.02;
        double d2 = this.random.nextGaussian() * 0.02;
        if (!this.level().isClientSide) {
            this.dead = true;
            new ExplosionTypes().netherExplosionEffect((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), ExplosionTypes.OreType.NETHERGOLD);
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleList.GOLD_EXPLOSION.get(), this.getX() + 0.5, this.getY(), this.getZ() + 0.5, 250, d1, d2, d0, 0.5);
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleList.REDSTONE_EXPLOSION.get(), this.getX() + 0.5, this.getY(), this.getZ() + 0.5, 250, d1, d2, d0, 0.5);
            this.discard();
            this.spawnLingeringCloud();
        }
    }
}

