/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.entities;

import com.cozary.ore_creeper.config.CommonConfigManager;
import com.cozary.ore_creeper.init.ModEntityTypes;
import com.cozary.ore_creeper.init.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class OrePrimedTnt
extends PrimedTnt {
    Random random = new Random();
    @Nullable
    private LivingEntity owner;

    public OrePrimedTnt(EntityType<? extends PrimedTnt> p_32076_, Level p_32077_) {
        super(ModEntityTypes.ORE_PRIMED_TNT.get(), p_32077_);
    }

    public OrePrimedTnt(Level p_32079_, double p_32080_, double p_32081_, double p_32082_) {
        this(ModEntityTypes.ORE_PRIMED_TNT.get(), p_32079_);
        this.setPos(p_32080_, p_32081_, p_32082_);
        double d0 = p_32079_.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.xo = p_32080_;
        this.yo = p_32081_;
        this.zo = p_32082_;
    }

    public static RegistryObject<EntityType<?>> getRandomEntityType() {
        ArrayList entityTypesList = new ArrayList(ModEntityTypes.ENTITY_LIST);
        if (!entityTypesList.isEmpty()) {
            Random random = new Random();
            return (RegistryObject)entityTypesList.get(random.nextInt(entityTypesList.size()));
        }
        return null;
    }

    public void explode() {
        this.level().playSound((Player)this.owner, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
        double d0 = this.random.nextGaussian() * 0.02;
        double d1 = this.random.nextGaussian() * 0.02;
        double d2 = this.random.nextGaussian() * 0.02;
        AABB targetBox = new AABB(this.position(), this.position()).inflate((double)CommonConfigManager.getConfig().oreTntExplosionRadius());
        List foundTarget = this.level().getEntitiesOfClass(Creeper.class, targetBox);
        ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX() + 0.5, this.getY(), this.getZ() + 0.5, 1, d1, d2, d0, 0.5);
        for (LivingEntity livingEntity : foundTarget) {
            livingEntity.remove(Entity.RemovalReason.DISCARDED);
            Entity entities = Objects.requireNonNull(OrePrimedTnt.getRandomEntityType()).get().create(this.level());
            assert (entities != null);
            entities.setPos(livingEntity.position());
            this.level().addFreshEntity(entities);
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.POOF, entities.getX() + 0.5, entities.getY(), entities.getZ() + 0.5, 100, d1, d2, d0, 0.5);
        }
    }
}

