/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.util;

import com.cozary.ore_creeper.config.CommonConfigManager;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ExplosionTypes {
    public void oreExplosionEffect(Entity entity, Level entityWorld, double entityX, double entityY, double entityZ, OreType oreType) {
        double radius = 0.0;
        switch (oreType.ordinal()) {
            case 0: {
                radius = CommonConfigManager.getConfig().coalCreeperExplosionRadius();
                break;
            }
            case 1: {
                radius = CommonConfigManager.getConfig().copperCreeperExplosionRadius();
                break;
            }
            case 2: {
                radius = CommonConfigManager.getConfig().diamondCreeperExplosionRadius();
                break;
            }
            case 3: {
                radius = CommonConfigManager.getConfig().emeraldCreeperExplosionRadius();
                break;
            }
            case 4: {
                radius = CommonConfigManager.getConfig().goldCreeperExplosionRadius();
                break;
            }
            case 5: {
                radius = CommonConfigManager.getConfig().ironCreeperExplosionRadius();
                break;
            }
            case 6: {
                radius = CommonConfigManager.getConfig().lapisLazuliCreeperExplosionRadius();
                break;
            }
            case 7: {
                radius = CommonConfigManager.getConfig().redstoneCreeperExplosionRadius();
            }
        }
        if (entity instanceof PowerableMob) {
            radius = ((PowerableMob)entity).isPowered() ? radius * 1.5 : radius;
        }
        entityWorld.explode(entity, entityX, entityY, entityZ, CommonConfigManager.getConfig().oreCreepersExplodeLikeNormalCreepers() ? (float)radius : 0.0f, CommonConfigManager.getConfig().oreCreepersExplodeLikeNormalCreepers() ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
        int x = (int)(-radius);
        while ((double)x <= radius) {
            int y = (int)(-radius);
            while ((double)y <= radius) {
                int z = (int)(-radius);
                while ((double)z <= radius) {
                    BlockPos blockPos = new BlockPos((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                    BlockState state = entityWorld.getBlockState(blockPos);
                    if (state != null && state.getBlock() != null) {
                        Block stoneBlock = state.getBlock();
                        Block[] baseBlockList = new Block[]{Blocks.STONE, Blocks.GRANITE, Blocks.DIORITE, Blocks.ANDESITE, Blocks.GRAVEL, Blocks.CLAY, Blocks.DRIPSTONE_BLOCK, Blocks.DEEPSLATE, Blocks.CALCITE, Blocks.TUFF};
                        if (stoneBlock != null && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius && Arrays.asList(baseBlockList).contains(stoneBlock)) {
                            if (stoneBlock.defaultBlockState() == Blocks.DEEPSLATE.defaultBlockState()) {
                                switch (new Random().nextInt(10) + 1) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        entityWorld.setBlockAndUpdate(blockPos, stoneBlock.defaultBlockState());
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: {
                                        entityWorld.setBlockAndUpdate(blockPos, oreType.getDeepslateOreBlock().defaultBlockState());
                                        break;
                                    }
                                    case 10: {
                                        if (oreType.getRawBlock() == null) break;
                                        entityWorld.setBlockAndUpdate(blockPos, oreType.getRawBlock().defaultBlockState());
                                    }
                                }
                            } else {
                                switch (new Random().nextInt(10) + 1) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        entityWorld.setBlockAndUpdate(blockPos, stoneBlock.defaultBlockState());
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: {
                                        entityWorld.setBlockAndUpdate(blockPos, oreType.getOreBlock().defaultBlockState());
                                        break;
                                    }
                                    case 10: {
                                        if (oreType.getRawBlock() == null) break;
                                        entityWorld.setBlockAndUpdate(blockPos, oreType.getRawBlock().defaultBlockState());
                                    }
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void netherExplosionEffect(Entity entity, Level entityWorld, double entityX, double entityY, double entityZ, OreType oreType) {
        double radius = 0.0;
        switch (oreType.ordinal()) {
            case 8: {
                radius = CommonConfigManager.getConfig().netherGoldCreeperExplosionRadius();
                break;
            }
            case 9: {
                radius = CommonConfigManager.getConfig().netherQuartzCreeperExplosionRadius();
                break;
            }
            case 10: {
                radius = CommonConfigManager.getConfig().ancientDebrisCreeperExplosionRadius();
            }
        }
        if (entity instanceof PowerableMob) {
            radius = ((PowerableMob)entity).isPowered() ? radius * 1.5 : radius;
        }
        entityWorld.explode(entity, entityX, entityY, entityZ, CommonConfigManager.getConfig().oreCreepersExplodeLikeNormalCreepers() ? (float)radius : 0.0f, CommonConfigManager.getConfig().oreCreepersExplodeLikeNormalCreepers() ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
        int x = (int)(-radius);
        while ((double)x <= radius) {
            int y = (int)(-radius);
            while ((double)y <= radius) {
                int z = (int)(-radius);
                while ((double)z <= radius) {
                    BlockPos blockPos = new BlockPos((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                    BlockState state = entityWorld.getBlockState(blockPos);
                    if (state != null && state.getBlock() != null) {
                        Block stoneBlock = state.getBlock();
                        Block baseBlock = Blocks.NETHERRACK;
                        if (stoneBlock != null && baseBlock == stoneBlock && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            switch (new Random().nextInt(10) + 1) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    entityWorld.setBlockAndUpdate(blockPos, stoneBlock.defaultBlockState());
                                    break;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: {
                                    entityWorld.setBlockAndUpdate(blockPos, oreType.getOreBlock().defaultBlockState());
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static enum OreType {
        COAL(Blocks.COAL_ORE, Blocks.COAL_BLOCK, Blocks.DEEPSLATE_COAL_ORE),
        COPPER(Blocks.COPPER_ORE, Blocks.RAW_COPPER_BLOCK, Blocks.DEEPSLATE_COPPER_ORE),
        DIAMOND(Blocks.DIAMOND_ORE, null, Blocks.DEEPSLATE_DIAMOND_ORE),
        EMERALD(Blocks.EMERALD_ORE, null, Blocks.DEEPSLATE_EMERALD_ORE),
        GOLD(Blocks.GOLD_ORE, Blocks.RAW_GOLD_BLOCK, Blocks.DEEPSLATE_GOLD_ORE),
        IRON(Blocks.IRON_ORE, Blocks.RAW_IRON_BLOCK, Blocks.DEEPSLATE_IRON_ORE),
        LAPIS(Blocks.LAPIS_ORE, null, Blocks.DEEPSLATE_LAPIS_ORE),
        REDSTONE(Blocks.REDSTONE_ORE, null, Blocks.DEEPSLATE_REDSTONE_ORE),
        NETHERGOLD(Blocks.NETHER_GOLD_ORE, Blocks.RAW_GOLD_BLOCK, null),
        NETHERQUARTZ(Blocks.NETHER_QUARTZ_ORE, null, null),
        ANCIENT_DEBRIS(Blocks.ANCIENT_DEBRIS, null, null);

        private final Block oreBlock;
        private final Block rawBlock;
        private final Block deepslateOreBlock;

        private OreType(Block oreBlock, Block rawBlock, Block deepslateOreBlock) {
            this.oreBlock = oreBlock;
            this.rawBlock = rawBlock;
            this.deepslateOreBlock = deepslateOreBlock;
        }

        public Block getOreBlock() {
            return this.oreBlock;
        }

        public Block getRawBlock() {
            return this.rawBlock;
        }

        public Block getDeepslateOreBlock() {
            return this.deepslateOreBlock;
        }
    }
}

