/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.client.render;

import com.cozary.ore_creeper.entities.OrePrimedTnt;
import com.cozary.ore_creeper.init.ModBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.TntRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class OreTntRenderer
extends EntityRenderer<OrePrimedTnt, TntRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public OreTntRenderer(EntityRendererProvider.Context p_174426_) {
        super(p_174426_);
        this.shadowRadius = 0.5f;
        this.blockRenderer = p_174426_.getBlockRenderDispatcher();
    }

    public TntRenderState createRenderState() {
        return new TntRenderState();
    }

    public void render(TntRenderState tntRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5f, 0.0f);
        float f = tntRenderState.fuseRemainingInTicks;
        if (tntRenderState.fuseRemainingInTicks < 10.0f) {
            float f1 = 1.0f - tntRenderState.fuseRemainingInTicks / 10.0f;
            f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
            f1 *= f1;
            f1 *= f1;
            float f2 = 1.0f + f1 * 0.3f;
            poseStack.scale(f2, f2, f2);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5f, -0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)ModBlocks.ORE_TNT.get().defaultBlockState(), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, ((int)f / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.popPose();
        super.render((EntityRenderState)tntRenderState, poseStack, multiBufferSource, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull OrePrimedTnt p_116175_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void extractRenderState(OrePrimedTnt p_361380_, TntRenderState p_364625_, float p_360472_) {
        super.extractRenderState((Entity)p_361380_, (EntityRenderState)p_364625_, p_360472_);
        p_364625_.fuseRemainingInTicks = (float)p_361380_.getFuse() - p_360472_ + 1.0f;
        p_364625_.blockState = p_361380_.getBlockState();
    }
}

