/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.entities;

import com.cozary.ore_creeper.config.CommonConfigManager;
import com.cozary.ore_creeper.entities.AbstractOreCreeperEntity;
import com.cozary.ore_creeper.init.ModTags;
import com.cozary.ore_creeper.init.ParticleList;
import com.cozary.ore_creeper.util.ExplosionTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class DiamondCreeperEntity
extends AbstractOreCreeperEntity {
    public DiamondCreeperEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static boolean canOreCreeperSpawn(EntityType<? extends AbstractOreCreeperEntity> creeper, ServerLevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return (float)pos.getY() < CommonConfigManager.getConfig().diamondCreeperMaxSpawnYLevel() && world.getBlockState(pos.below()).is(ModTags.SPAWNABLE_BLOCKS) && DiamondCreeperEntity.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && DiamondCreeperEntity.checkMobSpawnRules(creeper, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random);
    }

    public void explodeCreeper() {
        double d0 = this.random.nextGaussian() * 0.02;
        double d1 = this.random.nextGaussian() * 0.02;
        double d2 = this.random.nextGaussian() * 0.02;
        if (!this.level().isClientSide) {
            this.dead = true;
            new ExplosionTypes().oreExplosionEffect((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), ExplosionTypes.OreType.DIAMOND);
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleList.DIAMOND_EXPLOSION.get(), this.getX() + 0.5, this.getY(), this.getZ() + 0.5, 500, d1, d2, d0, 0.5);
            this.discard();
            this.spawnLingeringCloud();
        }
    }
}

