/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.pastlife.lives.ConfigManager;
import net.mat0u5.pastlife.utils.PlayerUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0814381;
import net.minecraft.unmapped.C_2670477;
import net.minecraft.unmapped.C_3292284;

public class LivesManager
extends ConfigManager {
    private Map<UUID, Integer> livesMap = new HashMap<UUID, Integer>();

    public LivesManager() {
        super(".", "_pastlife_lives.txt");
    }

    private void saveLives(C_3292284 player, int lives) {
        this.setProperty(player.m_6689989(), String.valueOf(lives));
        this.livesMap.put(player.m_2013188(), lives);
    }

    private int loadLives(C_3292284 player) {
        int lives = this.getOrCreateInt(player.m_6689989(), 6);
        this.livesMap.put(player.m_2013188(), lives);
        return lives;
    }

    public int getLives(C_3292284 player) {
        if (this.livesMap.containsKey(player.m_2013188())) {
            return this.livesMap.get(player.m_2013188());
        }
        return this.loadLives(player);
    }

    public void setLives(C_3292284 player, int lives) {
        if (lives < 0) {
            lives = 0;
        }
        this.saveLives(player, lives);
        if (lives == 0) {
            PlayerUtils.broadcast("\u00a78" + player.m_6689989() + "\u00a7f ran out of lives.");
            player.m_2325657(C_2670477.C_3802308.f_1944140);
        }
        this.scoreboardUpdate(player);
    }

    public void addLives(C_3292284 player, int lives) {
        int currentLives = this.loadLives(player);
        this.setLives(player, currentLives += lives);
    }

    public void scoreboardUpdate(C_3292284 player) {
        int lives = this.getLives(player);
        MinecraftServer server = player.m_2489918();
        if (server == null) {
            return;
        }
        C_0814381 scoreboard = server.m_4667880(0).m_5847414();
        scoreboard.m_4288528(player.m_6689989(), scoreboard.m_7155338("Lives")).m_9973427(lives);
        if (lives == 0 && !server.m_8526012().m_6078293(player.m_2101945())) {
            player.m_2325657(C_2670477.C_3802308.f_1944140);
        }
        this.teamUpdate(player, lives, scoreboard);
    }

    public void teamUpdate(C_3292284 player, int lives, C_0814381 scoreboard) {
        String teamName = "Dead";
        if (lives == 1) {
            teamName = "Red";
        }
        if (lives == 2) {
            teamName = "Yellow";
        }
        if (lives == 3) {
            teamName = "Green";
        }
        if (lives >= 4) {
            teamName = "DarkGreen";
        }
        scoreboard.m_1727093(player.m_6689989(), teamName);
    }
}

