/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.secretsociety;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.pastlife.Main;
import net.mat0u5.pastlife.utils.PlayerUtils;
import net.mat0u5.pastlife.utils.TaskScheduler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_1161898;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_9590849;

public class SecretSociety {
    public static List<UUID> members = new ArrayList<UUID>();
    public static List<UUID> yetToInitiate = new ArrayList<UUID>();
    public static boolean active = false;
    public static boolean began = false;
    public static boolean ended = false;
    public static long ticks = 0L;
    public static String secretWord = "Duck";
    public static final int MEMBERS = 3;
    public static final int INITIATE_MESSAGE_DELAYS = 300;
    public static final String[] randomWords = new String[]{"Hammer", "Magnet", "Throne", "Gravity", "Puzzle", "Spiral", "Pivot", "Flare"};
    public static Random rnd = new Random();

    public static void tick(MinecraftServer server) {
        if (!active) {
            return;
        }
        if (yetToInitiate.isEmpty()) {
            return;
        }
        if (++ticks < 250L) {
            return;
        }
        if (ticks % 300L == 0L) {
            ArrayList players = new ArrayList(server.m_8526012().m_8800532());
            for (C_3292284 player : players) {
                if (!yetToInitiate.contains(player.m_2013188())) continue;
                PlayerUtils.broadcastToPlayer(player, "\u00a77When you are alone, type \"/initiate\"");
            }
        }
    }

    public static void beginSociety(MinecraftServer server) {
        String randomWord = randomWords[rnd.nextInt(randomWords.length)];
        SecretSociety.beginSociety(server, randomWord);
    }

    public static void beginSociety(MinecraftServer server, String word) {
        secretWord = word;
        active = true;
        began = true;
        ended = false;
        ticks = 0L;
        members.clear();
        yetToInitiate.clear();
        ArrayList players = new ArrayList(server.m_8526012().m_8800532());
        Collections.shuffle(players);
        ArrayList<C_3292284> memberPlayers = new ArrayList<C_3292284>();
        for (C_3292284 player : players) {
            if (player == null || Main.livesManager != null && Main.livesManager.getLives(player) <= 0 || members.size() >= 3) continue;
            memberPlayers.add(player);
            members.add(player.m_2013188());
            Main.log(player.m_6689989() + " has been chosen as a member of the Secret Society.");
        }
        yetToInitiate = new ArrayList<UUID>(members);
        PlayerUtils.broadcastToPlayers(memberPlayers, "\u00a77Do not read out loud. Only you will see the way forward.");
        TaskScheduler.scheduleTask(30, () -> {
            PlayerUtils.playSoundToAllPlayers("secretsociety_whisper", 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(memberPlayers, "\u00a7cThe Society calls", 0, 30, 0);
        });
        TaskScheduler.scheduleTask(45, () -> PlayerUtils.sendTitleToPlayersNoReset(memberPlayers, "\u00a7cThe Society calls.", 0, 30, 0));
        TaskScheduler.scheduleTask(60, () -> PlayerUtils.sendTitleToPlayersNoReset(memberPlayers, "\u00a7cThe Society calls..", 0, 30, 0));
        TaskScheduler.scheduleTask(75, () -> PlayerUtils.sendTitleToPlayersNoReset(memberPlayers, "\u00a7cThe Society calls...", 0, 45, 30));
        TaskScheduler.scheduleTask(145, () -> PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7cTake yourself somewhere quiet", 20, 60, 20));
    }

    public static void initiatePlayer(C_3292284 player) {
        if (!members.contains(player.m_2013188())) {
            return;
        }
        if (!yetToInitiate.contains(player.m_2013188())) {
            return;
        }
        yetToInitiate.remove(player.m_2013188());
        PlayerUtils.playSoundToPlayer(player, "secretsociety_whisper", 1.0f, 1.0f);
        int currentTime = 20;
        TaskScheduler.scheduleTask(currentTime, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77You have been chosen to be part of the \u00a7csecret society\u00a77."));
        TaskScheduler.scheduleTask(currentTime += 50, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77There are \u00a7c2\u00a77 other members. Find them."));
        TaskScheduler.scheduleTask(currentTime += 80, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77Together, secretly kill \u00a7c2\u00a77 other players by \u00a7cnon-pvp\u00a77 means."));
        TaskScheduler.scheduleTask(currentTime += 100, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77Find the other members with the secret word:"));
        TaskScheduler.scheduleTask(currentTime += 80, () -> PlayerUtils.broadcastToPlayer(player, "\u00a7d\"" + secretWord + "\""));
        TaskScheduler.scheduleTask(currentTime += 80, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77Type \"/society success\" when you complete your goal."));
        TaskScheduler.scheduleTask(currentTime += 80, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77Don't tell anyone else about the society."));
        TaskScheduler.scheduleTask(currentTime += 70, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77If you fail..."));
        TaskScheduler.scheduleTask(currentTime += 70, () -> PlayerUtils.broadcastToPlayer(player, "\u00a77Type \"/society fail\", and you all lose \u00a7c2 lives\u00a77."));
    }

    public static void end(MinecraftServer server, boolean success) {
        if (ended) {
            return;
        }
        active = false;
        ended = true;
        ticks = 0L;
        PlayerUtils.playSoundToAllPlayers("secretsociety_whisper", 1.0f, 1.0f);
        ArrayList players = new ArrayList(server.m_8526012().m_8800532());
        ArrayList<C_3292284> memberPlayers = new ArrayList<C_3292284>();
        for (C_3292284 player : players) {
            if (player == null || !members.contains(player.m_2013188())) continue;
            memberPlayers.add(player);
        }
        if (success) {
            PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7aThe Society is pleased", 20, 30, 20);
            TaskScheduler.scheduleTask(75, () -> PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7aYou will not be punished", 20, 30, 20));
            TaskScheduler.scheduleTask(150, () -> PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7cYou are still sworn to secrecy", 20, 30, 20));
        } else {
            PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7cThe Society is displeased", 20, 30, 20);
            TaskScheduler.scheduleTask(75, () -> PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7cYou will be punished", 20, 30, 20));
            TaskScheduler.scheduleTask(110, () -> {
                for (C_3292284 member : memberPlayers) {
                    if (member.m_8116444() <= 1.0f) {
                        member.m_9455713(2.0f);
                    }
                    member.m_8726131(C_1161898.m_5682305((C_9590849)member), 1.0f);
                    if (Main.livesManager == null) continue;
                    Main.livesManager.addLives(member, -2);
                }
            });
            TaskScheduler.scheduleTask(150, () -> PlayerUtils.sendSubtitleToPlayers(memberPlayers, "\u00a7cYou are still sworn to secrecy", 20, 30, 20));
        }
    }
}

