/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.mixin;

import net.mat0u5.pastlife.interfaces.IPlayerEntity;
import net.mat0u5.pastlife.utils.WorldBorderManager;
import net.minecraft.unmapped.C_9590849;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={C_9590849.class})
public class PlayerEntityMixin
implements IPlayerEntity {
    @Unique
    private String playerUUID;
    @Unique
    private String playerName;

    @Override
    public void setUUID(String uuid) {
        this.playerUUID = uuid;
    }

    @Override
    public String getUUID() {
        return this.playerUUID;
    }

    @Override
    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getName() {
        return this.playerName;
    }

    @Inject(method={"registerCloak"}, at={@At(value="HEAD")}, cancellable=true)
    public void registerCloak(CallbackInfo ci) {
        C_9590849 entity = (C_9590849)this;
        if (this.playerUUID != null) {
            entity.f_0877927 = entity.f_5067293 = "https://crafatar.com/capes/" + this.playerUUID + ".png";
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        C_9590849 player = (C_9590849)this;
        if (!WorldBorderManager.initialized || player.f_4703454.f_6669533.f_9892467) {
            return;
        }
        double centerX = WorldBorderManager.centerX;
        double centerZ = WorldBorderManager.centerZ;
        if (WorldBorderManager.isOutsideBorder(player.f_6638345, player.f_9103758)) {
            double halfSize = (double)WorldBorderManager.borderSize / 2.0;
            double posX = player.f_6638345;
            double posY = player.f_1187082;
            double posZ = player.f_9103758;
            double newX = posX;
            double newZ = posZ;
            if (Math.abs(posX - centerX) > halfSize) {
                newX = centerX + halfSize * Math.signum(posX - centerX);
            }
            if (Math.abs(posZ - centerZ) > halfSize) {
                newZ = centerZ + halfSize * Math.signum(posZ - centerZ);
            }
            if (Math.abs(posX - newX) > 1.0 || Math.abs(posZ - newZ) > 1.0) {
                return;
            }
            if (newX != posX || newZ != posZ) {
                player.m_4956544(newX, posY, newZ);
                player.f_7931186 = 0.0;
                player.f_3399559 = 0.0;
            }
        }
    }
}

