/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import java.util.HashMap;
import java.util.Map;
import net.mat0u5.pastlife.Main;
import net.mat0u5.pastlife.packets.LivesUpdatePacket;
import net.minecraft.unmapped.C_9590849;

public class ClientLivesManager {
    private static Map<String, Integer> livesMap = new HashMap<String, Integer>();

    public static void handlePacket(LivesUpdatePacket packet) {
        String playerName = packet.playerName;
        int lives = packet.lives;
        if (playerName == null || playerName.isEmpty()) {
            Main.error("Invalid player name received in LivesUpdatePacket.");
            return;
        }
        livesMap.put(playerName, lives);
    }

    public static Integer getPlayerLives(C_9590849 player) {
        return ClientLivesManager.getPlayerLives(player.f_4437619);
    }

    public static Integer getPlayerLives(String playerName) {
        if (livesMap.containsKey(playerName)) {
            return livesMap.get(playerName);
        }
        return null;
    }

    public static String getColorCode(C_9590849 player) {
        return ClientLivesManager.getColorCode(player.f_4437619);
    }

    public static String getColorCode(String playerName) {
        Integer lives = ClientLivesManager.getPlayerLives(playerName);
        if (lives == null) {
            return null;
        }
        if (lives <= 0) {
            return "\u00a78";
        }
        if (lives == 1) {
            return "\u00a7c";
        }
        if (lives == 2) {
            return "\u00a7e";
        }
        if (lives == 3) {
            return "\u00a7a";
        }
        return "\u00a72";
    }
}

