/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.mixin;

import net.mat0u5.pastlife.utils.WorldBorderManager;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8398976;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={C_8398976.class})
public class WorldRendererMixin {
    @Shadow
    private Minecraft f_7980673;
    @Shadow
    private C_5553933 f_5815929;
    private static int frameCounter = 0;
    private static boolean shouldRenderBorder = false;
    private static double distToBorder = 200.0;

    @Inject(method={"render(IIID)I"}, at={@At(value="RETURN")})
    private void renderWorldBorder(int renderStartIndex, int chunksToRender, int renderStage, double tickDelta, CallbackInfoReturnable<Integer> cir) {
        if (renderStage != 0) {
            return;
        }
        C_1023567 player = this.f_7980673.f_6058446;
        if (player == null) {
            return;
        }
        if (!WorldBorderManager.initialized || !player.f_4703454.f_6669533.m_4577091()) {
            return;
        }
        double centerX = WorldBorderManager.centerX;
        double centerZ = WorldBorderManager.centerZ;
        if (++frameCounter % 10 == 0) {
            double playerX = player.f_6638345;
            double playerZ = player.f_9103758;
            double halfSize = (double)WorldBorderManager.borderSize / 2.0;
            distToBorder = Math.min(Math.abs(playerX - (centerX - halfSize)), Math.min(Math.abs(playerX - (centerX + halfSize)), Math.min(Math.abs(playerZ - (centerZ - halfSize)), Math.abs(playerZ - (centerZ + halfSize)))));
            shouldRenderBorder = distToBorder < 32.0;
            frameCounter = 0;
        }
        if (shouldRenderBorder) {
            double halfSize = (double)WorldBorderManager.borderSize / 2.0;
            this.renderBorderWalls(centerX, centerZ, halfSize, tickDelta);
        }
    }

    private void renderBorderWalls(double centerX, double centerZ, double halfSize, double tickDelta) {
        double wallMaxZ;
        double wallMinZ;
        double wallMaxX;
        double wallMinX;
        boolean renderEast;
        C_1023567 player = this.f_7980673.f_6058446;
        if (player == null) {
            return;
        }
        double playerX = player.f_7928345 + (player.f_6638345 - player.f_7928345) * tickDelta;
        double playerY = player.f_6367672 + (player.f_1187082 - player.f_6367672) * tickDelta;
        double playerZ = player.f_5666338 + (player.f_9103758 - player.f_5666338) * tickDelta;
        double offset = 0.03;
        double minX = centerX - halfSize + offset;
        double maxX = centerX + halfSize - offset;
        double minZ = centerZ - halfSize + offset;
        double maxZ = centerZ + halfSize - offset;
        double maxDistance = Math.max(10.0, 64.0 - distToBorder * 2.0);
        boolean renderNorth = playerZ - (centerZ - halfSize) < 32.0;
        boolean renderSouth = centerZ + halfSize - playerZ < 32.0;
        boolean renderWest = playerX - (centerX - halfSize) < 32.0;
        boolean bl = renderEast = centerX + halfSize - playerX < 32.0;
        if (!(renderNorth || renderSouth || renderWest || renderEast)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glColor4f((float)0.0f, (float)0.5f, (float)1.0f, (float)0.2f);
        GL11.glTranslated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        double minY = Math.max(0.0, playerY - 32.0);
        double maxY = Math.min(128.0, playerY + 32.0);
        GL11.glBegin((int)7);
        if (renderNorth) {
            wallMinX = Math.max(minX, playerX - maxDistance);
            wallMaxX = Math.min(maxX, playerX + maxDistance);
            GL11.glVertex3d((double)wallMinX, (double)minY, (double)minZ);
            GL11.glVertex3d((double)wallMaxX, (double)minY, (double)minZ);
            GL11.glVertex3d((double)wallMaxX, (double)maxY, (double)minZ);
            GL11.glVertex3d((double)wallMinX, (double)maxY, (double)minZ);
        }
        if (renderSouth) {
            wallMinX = Math.max(minX, playerX - maxDistance);
            wallMaxX = Math.min(maxX, playerX + maxDistance);
            GL11.glVertex3d((double)wallMaxX, (double)minY, (double)maxZ);
            GL11.glVertex3d((double)wallMinX, (double)minY, (double)maxZ);
            GL11.glVertex3d((double)wallMinX, (double)maxY, (double)maxZ);
            GL11.glVertex3d((double)wallMaxX, (double)maxY, (double)maxZ);
        }
        if (renderWest) {
            wallMinZ = Math.max(minZ, playerZ - maxDistance);
            wallMaxZ = Math.min(maxZ, playerZ + maxDistance);
            GL11.glVertex3d((double)minX, (double)minY, (double)wallMaxZ);
            GL11.glVertex3d((double)minX, (double)minY, (double)wallMinZ);
            GL11.glVertex3d((double)minX, (double)maxY, (double)wallMinZ);
            GL11.glVertex3d((double)minX, (double)maxY, (double)wallMaxZ);
        }
        if (renderEast) {
            wallMinZ = Math.max(minZ, playerZ - maxDistance);
            wallMaxZ = Math.min(maxZ, playerZ + maxDistance);
            GL11.glVertex3d((double)maxX, (double)minY, (double)wallMinZ);
            GL11.glVertex3d((double)maxX, (double)minY, (double)wallMaxZ);
            GL11.glVertex3d((double)maxX, (double)maxY, (double)wallMaxZ);
            GL11.glVertex3d((double)maxX, (double)maxY, (double)wallMinZ);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

