/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import net.mat0u5.pastlife.Main;
import net.mat0u5.pastlife.interfaces.IPlayerEntity;

public class PlayerUtils {
    public static void loadUUID(IPlayerEntity accessor) {
        String[] apiEndpoints;
        String playerName = accessor.getName();
        if (playerName == null || playerName.trim().isEmpty()) {
            return;
        }
        for (String endpoint : apiEndpoints = new String[]{"http://api.mojang.com/users/profiles/minecraft/" + playerName.trim(), "https://api.mojang.com/users/profiles/minecraft/" + playerName.trim()}) {
            if (!PlayerUtils.tryLoadUUIDFromEndpoint(accessor, playerName, endpoint)) continue;
            return;
        }
        Main.log("Official API endpoints failed for player: " + playerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryLoadUUIDFromEndpoint(IPlayerEntity accessor, String playerName, String apiUrl) {
        boolean bl;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(apiUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Minecraft-Beta-Mod/1.0");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 307 || responseCode == 301 || responseCode == 302) {
                String redirectUrl = connection.getHeaderField("Location");
                if (redirectUrl != null && redirectUrl.startsWith("http://")) {
                    Main.log("Following HTTP redirect for: " + playerName);
                    connection.disconnect();
                    boolean bl2 = PlayerUtils.tryLoadUUIDFromEndpoint(accessor, playerName, redirectUrl);
                    return bl2;
                }
                Main.log("Skipping HTTPS redirect for: " + playerName);
                boolean bl3 = false;
                return bl3;
            }
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse(response.toString()).getAsJsonObject();
                if (json.has("id") && !json.get("id").isJsonNull()) {
                    String uuidStr = json.get("id").getAsString();
                    accessor.setUUID(uuidStr);
                    Main.log("Successfully loaded UUID for player: " + playerName);
                    boolean bl4 = true;
                    return bl4;
                }
                Main.log("No UUID found for player: " + playerName);
                boolean bl5 = false;
                return bl5;
            }
            if (responseCode == 204) {
                Main.log("Player does not exist: " + playerName);
                boolean bl6 = false;
                return bl6;
            }
            if (responseCode == 404) {
                Main.log("Player not found: " + playerName);
                boolean bl7 = false;
                return bl7;
            }
            if (responseCode == 429) {
                Main.log("Rate limited by Mojang API. Try again later.");
                boolean bl8 = false;
                return bl8;
            }
            Main.log("API endpoint " + apiUrl + " returned error code: " + responseCode);
            boolean bl9 = false;
            return bl9;
        }
        catch (UnknownHostException e) {
            Main.log("No internet connection or DNS resolution failed");
            bl = false;
            return bl;
        }
        catch (SocketTimeoutException e) {
            Main.log("Connection timeout for endpoint: " + apiUrl);
            bl = false;
            return bl;
        }
        catch (Exception e) {
            Main.log("Error with endpoint " + apiUrl + ": " + e.getMessage());
            bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void loadUUIDAlternative(IPlayerEntity accessor) {
        String[] altServices;
        String playerName = accessor.getName();
        if (playerName == null || playerName.trim().isEmpty()) {
            return;
        }
        for (String serviceUrl : altServices = new String[]{"https://api.minetools.eu/uuid/" + playerName.trim(), "https://api.ashcon.app/mojang/v2/user/" + playerName.trim(), "https://playerdb.co/api/player/minecraft/" + playerName.trim()}) {
            if (!PlayerUtils.tryAlternativeService(accessor, playerName, serviceUrl)) continue;
            return;
        }
        Main.log("All alternative services failed for: " + playerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryAlternativeService(IPlayerEntity accessor, String playerName, String serviceUrl) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(serviceUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Minecraft-Beta-Mod/1.0");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse(response.toString()).getAsJsonObject();
                String uuidStr = PlayerUtils.extractUUIDFromResponse(json, serviceUrl);
                if (uuidStr != null && !uuidStr.isEmpty()) {
                    accessor.setUUID(uuidStr);
                    Main.log("Successfully loaded UUID via alternative service for: " + playerName);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            Main.log("Alternative service " + serviceUrl + " failed: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    private static String extractUUIDFromResponse(JsonObject json, String serviceUrl) {
        try {
            JsonObject player;
            if (serviceUrl.contains("minetools.eu")) {
                if (json.has("id")) {
                    return json.get("id").getAsString().replace("-", "");
                }
            } else if (serviceUrl.contains("ashcon.app")) {
                if (json.has("uuid")) {
                    return json.get("uuid").getAsString().replace("-", "");
                }
            } else if (serviceUrl.contains("playerdb.co") && json.has("data") && json.getAsJsonObject("data").has("player") && (player = json.getAsJsonObject("data").getAsJsonObject("player")).has("id")) {
                return player.get("id").getAsString().replace("-", "");
            }
        }
        catch (Exception e) {
            Main.log("Error parsing response from " + serviceUrl + ": " + e.getMessage());
        }
        return null;
    }

    public static void loadUUIDManual(IPlayerEntity accessor) {
        String playerName = accessor.getName();
        if (playerName == null) {
            return;
        }
        Main.log("Could not fetch UUID for " + playerName + " - using offline mode UUID");
        String offlineUUID = PlayerUtils.generateOfflineUUID(playerName);
        accessor.setUUID(offlineUUID);
    }

    private static String generateOfflineUUID(String username) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(("OfflinePlayer:" + username).getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : hash) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return Integer.toHexString(username.hashCode()) + "000000000000000000000000";
        }
    }

    public static void loadUUIDWithAllMethods(IPlayerEntity accessor) {
        String playerName = accessor.getName();
        if (playerName == null || playerName.trim().isEmpty()) {
            return;
        }
        Main.log("Attempting to load UUID for: " + playerName);
        PlayerUtils.loadUUID(accessor);
        if (accessor.getUUID() != null && !accessor.getUUID().isEmpty()) {
            return;
        }
        Main.log("Trying alternative UUID service...");
        PlayerUtils.loadUUIDAlternative(accessor);
        if (accessor.getUUID() != null && !accessor.getUUID().isEmpty()) {
            return;
        }
        Main.log("Generating offline UUID as fallback...");
        PlayerUtils.loadUUIDManual(accessor);
    }
}

