/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.client.utils;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.mat0u5.pastlife.Main;

public class ResourceHandler {
    public void copyBundledSingleFile(String resourcePath, Path targetFile) {
        try {
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            URL resourceUrl = this.getClass().getResource(resourcePath);
            if (resourceUrl == null) {
                Main.error("File not found: " + resourcePath);
                return;
            }
            if (resourceUrl.getProtocol().equals("file")) {
                this.handleSingleFileNormal(targetFile, resourceUrl);
            } else if (resourceUrl.getProtocol().equals("jar")) {
                this.handleSingleFileJar(targetFile, resourcePath);
            } else {
                Main.error("Unsupported resource protocol: " + resourceUrl.getProtocol());
            }
        }
        catch (Exception e) {
            Main.error("Error copying bundled file: " + resourcePath + "_" + e);
        }
    }

    private void handleSingleFileNormal(Path targetFile, URL resourceUrl) {
        try {
            Path sourcePath = Paths.get(resourceUrl.toURI());
            if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
                Files.copy(sourcePath, targetFile, StandardCopyOption.REPLACE_EXISTING);
                Main.log("Copied file: " + sourcePath + " -> " + targetFile);
            } else {
                Main.error("Source is not a regular file: " + sourcePath);
            }
        }
        catch (Exception e) {
            Main.error("Error copying bundled file." + e);
        }
    }

    private void handleSingleFileJar(Path targetFile, String resourcePath) {
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in == null) {
                Main.error("Could not find resource: " + resourcePath);
                return;
            }
            Files.copy(in, targetFile, StandardCopyOption.REPLACE_EXISTING);
            Main.log("Copied file from JAR: " + resourcePath + " -> " + targetFile);
        }
        catch (Exception e) {
            Main.error("Error copying file from JAR: " + resourcePath + "_" + e);
        }
    }
}

