/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.client.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_7799337;
import org.lwjgl.opengl.GL11;

public class TitleRenderer {
    private static final int[] COLOR_VALUES = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
    private String currentTitle = "";
    private String currentSubtitle = "";
    private int fadeInTime = 0;
    private int stayTime = 0;
    private int fadeOutTime = 0;
    private int startTick = 0;
    private boolean isActive = false;

    public static int getTextColor(String text) {
        if (text.length() < 2 || text.charAt(0) != '\u00a7') {
            return 0xFFFFFF;
        }
        char colorChar = text.charAt(1);
        if (colorChar >= '0' && colorChar <= '9') {
            return COLOR_VALUES[colorChar - 48];
        }
        if (colorChar >= 'a' && colorChar <= 'f') {
            return COLOR_VALUES[colorChar - 97 + 10];
        }
        if (colorChar >= 'A' && colorChar <= 'F') {
            return COLOR_VALUES[colorChar - 65 + 10];
        }
        return 0xFFFFFF;
    }

    public void showTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.currentTitle = title;
        this.currentSubtitle = subtitle;
        this.fadeInTime = fadeIn;
        this.stayTime = stay;
        this.fadeOutTime = fadeOut;
        this.startTick = 0;
        this.isActive = true;
    }

    public void renderTitle(Minecraft mc, float tickDelta) {
        int scaledY;
        int scaledX;
        if (!this.isActive) {
            return;
        }
        if (this.startTick == 0 && this.fadeInTime != 0) {
            return;
        }
        float currentProgress = (float)this.startTick + tickDelta;
        int totalTime = this.fadeInTime + this.stayTime + this.fadeOutTime;
        if (currentProgress >= (float)(totalTime - 1)) {
            this.isActive = false;
            return;
        }
        float alpha = this.calculateAlpha(currentProgress);
        int alpha255 = (int)(alpha * 255.0f);
        C_7799337 window = new C_7799337(mc.f_9967940, mc.f_0545414, mc.f_5990000);
        int width = window.m_1713651();
        int height = window.m_5421693();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        if (!this.currentTitle.isEmpty()) {
            String rawTitle = this.currentTitle;
            if (rawTitle.startsWith("\u00a7")) {
                rawTitle = rawTitle.substring(2);
            }
            float titleScale = 3.0f;
            GL11.glPushMatrix();
            GL11.glScalef((float)titleScale, (float)titleScale, (float)1.0f);
            int titleWidth = mc.f_0426313.m_0040387(rawTitle);
            scaledX = (int)(((float)width - (float)titleWidth * titleScale) / (2.0f * titleScale));
            scaledY = (int)((float)(height / 2 - 20) / titleScale);
            mc.f_0426313.m_1950885(rawTitle, scaledX, scaledY, TitleRenderer.getTextColor(this.currentTitle) + (alpha255 << 24));
            GL11.glPopMatrix();
        }
        if (!this.currentSubtitle.isEmpty()) {
            String rawSubtitle = this.currentSubtitle;
            if (rawSubtitle.startsWith("\u00a7")) {
                rawSubtitle = rawSubtitle.substring(2);
            }
            float subtitleScale = 2.0f;
            GL11.glPushMatrix();
            GL11.glScalef((float)subtitleScale, (float)subtitleScale, (float)1.0f);
            int subtitleWidth = mc.f_0426313.m_0040387(rawSubtitle);
            scaledX = (int)(((float)width - (float)subtitleWidth * subtitleScale) / (2.0f * subtitleScale));
            scaledY = (int)((float)(height / 2 + 30) / subtitleScale);
            mc.f_0426313.m_1950885(rawSubtitle, scaledX, scaledY, TitleRenderer.getTextColor(this.currentSubtitle) + (alpha255 << 24));
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    public void tick() {
        if (this.isActive) {
            ++this.startTick;
        }
    }

    private float calculateAlpha(float currentProgress) {
        if (currentProgress < (float)this.fadeInTime) {
            return currentProgress / (float)this.fadeInTime;
        }
        if (currentProgress < (float)(this.fadeInTime + this.stayTime)) {
            return 1.0f;
        }
        float fadeOutStart = this.fadeInTime + this.stayTime;
        float fadeOutProgress = currentProgress - fadeOutStart;
        return Math.max(0.0f, 1.0f - fadeOutProgress / (float)this.fadeOutTime);
    }
}

