/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife;

import java.util.UUID;
import java.util.logging.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.mat0u5.pastlife.boogeyman.BoogeymanCommand;
import net.mat0u5.pastlife.lives.LivesCommand;
import net.mat0u5.pastlife.lives.LivesManager;
import net.mat0u5.pastlife.secretsociety.InitiateCommand;
import net.mat0u5.pastlife.secretsociety.SecretSocietyCommand;
import net.mat0u5.pastlife.utils.IClientHelper;
import net.mat0u5.pastlife.utils.TaskScheduler;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Main
implements ModInitializer {
    public static final String RESOURCEPACK_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-pastlife-8916bc1d49a79784de7df6477810e3ff78026f2a/pastlife.zip";
    public static final String RESOURCEPACK_HASH = "6304b625874dfe7603f6e5caf4978acaffcf0132";
    public static final String MOD_ID = "pastlife";
    public static Logger LOGGER = Logger.getLogger("pastlife");
    public static boolean initializedCommands = false;
    public static IClientHelper clientHelper;
    public static MinecraftServer server;
    public static LivesManager livesManager;

    public void onInitialize() {
        Main.log("[SERVER] Initializing Past Life!");
        livesManager = new LivesManager();
        CommandRegistrationCallback.EVENT.register(LivesCommand::register);
        CommandRegistrationCallback.EVENT.register(BoogeymanCommand::register);
        CommandRegistrationCallback.EVENT.register(SecretSocietyCommand::register);
        CommandRegistrationCallback.EVENT.register(InitiateCommand::register);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Main.onPlayerJoin(handler.field_14140));
    }

    private static void onPlayerJoin(class_3222 player) {
        MinecraftServer thisServer = player.method_5682();
        if (thisServer == null) {
            return;
        }
        TaskScheduler.scheduleTask(5, () -> thisServer.method_3734().method_9249(thisServer.method_3739().method_9217(), "recipe give @a pastlife:tnt_variation"));
    }

    public static void log(String message) {
        if (LOGGER != null) {
            LOGGER.info(message);
        } else {
            System.out.println("[Past Life] " + message);
        }
    }

    public static void error(String message) {
        if (LOGGER != null) {
            LOGGER.warning(message);
        } else {
            System.out.println("[Past Life] " + message);
        }
    }

    public static void setClientHelper(IClientHelper helper) {
        clientHelper = helper;
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isClientPlayer(UUID uuid) {
        if (!Main.isClient()) {
            return false;
        }
        return clientHelper != null && clientHelper.isMainClientPlayer(uuid);
    }
}

