/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.pastlife.lives.ConfigManager;
import net.mat0u5.pastlife.utils.PlayerUtils;
import net.minecraft.class_1934;
import net.minecraft.class_269;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LivesManager
extends ConfigManager {
    private Map<UUID, Integer> livesMap = new HashMap<UUID, Integer>();

    public LivesManager() {
        super(".", "_pastlife_lives.txt");
    }

    private void saveLives(class_3222 player, int lives) {
        this.setProperty(player.method_5820(), String.valueOf(lives));
        this.livesMap.put(player.method_5667(), lives);
    }

    private int loadLives(class_3222 player) {
        int lives = this.getOrCreateInt(player.method_5820(), 6);
        this.livesMap.put(player.method_5667(), lives);
        return lives;
    }

    public int getLives(class_3222 player) {
        if (this.livesMap.containsKey(player.method_5667())) {
            return this.livesMap.get(player.method_5667());
        }
        return this.loadLives(player);
    }

    public void setLives(class_3222 player, int lives) {
        if (lives < 0) {
            lives = 0;
        }
        this.saveLives(player, lives);
        if (lives == 0) {
            PlayerUtils.broadcast("\u00a78" + player.method_5820() + "\u00a7f ran out of lives.");
            player.method_7336(class_1934.field_9219);
        }
        this.scoreboardUpdate(player);
    }

    public void addLives(class_3222 player, int lives) {
        int currentLives = this.loadLives(player);
        this.setLives(player, currentLives += lives);
    }

    public void scoreboardUpdate(class_3222 player) {
        int lives = this.getLives(player);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2995 scoreboard = server.method_3845();
        scoreboard.method_1180(player.method_5820(), scoreboard.method_1165("Lives")).method_1128(lives);
        if (lives == 0 && !PlayerUtils.isAdmin(player)) {
            player.method_7336(class_1934.field_9219);
        }
        this.teamUpdate(player, lives, (class_269)scoreboard);
    }

    public void teamUpdate(class_3222 player, int lives, class_269 scoreboard) {
        String teamName = "Dead";
        if (lives == 1) {
            teamName = "Red";
        }
        if (lives == 2) {
            teamName = "Yellow";
        }
        if (lives == 3) {
            teamName = "Green";
        }
        if (lives >= 4) {
            teamName = "DarkGreen";
        }
        scoreboard.method_1172(player.method_5820(), scoreboard.method_1153(teamName));
    }
}

