/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.mat0u5.pastlife.Main;

public abstract class ConfigManager {
    protected Properties properties = new Properties();
    protected String folderPath;
    protected String filePath;

    protected ConfigManager(String folderPath, String filePath) {
        this.folderPath = folderPath;
        this.filePath = folderPath + "/" + filePath;
        this.createFileIfNotExists();
        this.loadProperties();
        this.instantiateProperties();
    }

    protected void instantiateProperties() {
    }

    private void createFileIfNotExists() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        File configDir = new File(this.folderPath);
        if (!configDir.exists() && !configDir.mkdirs()) {
            Main.error("Failed to create folder " + configDir);
            return;
        }
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            try {
                if (!configFile.createNewFile()) {
                    Main.error("Failed to create file " + configFile);
                    return;
                }
                try (FileOutputStream output = new FileOutputStream(configFile);){
                    this.instantiateProperties();
                    this.properties.store(output, null);
                }
            }
            catch (IOException ex) {
                Main.error(ex.getMessage());
            }
        }
    }

    protected void loadProperties() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.filePath);){
            this.properties.load(input);
        }
        catch (IOException ex) {
            Main.error(ex.getMessage());
        }
    }

    protected void setProperty(String key, String value) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties.setProperty(key, value);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            Main.error(ex.getMessage());
        }
    }

    protected void removeProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        if (!this.properties.containsKey(key)) {
            return;
        }
        this.properties.remove(key);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            Main.error(ex.getMessage());
        }
    }

    protected void resetProperties() {
        this.properties.clear();
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            Main.error(ex.getMessage());
        }
    }

    protected String getProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return null;
        }
        if (this.properties == null) {
            return null;
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    protected String getOrCreateProperty(String key, String defaultValue) {
        if (this.folderPath == null || this.filePath == null) {
            return "";
        }
        if (this.properties == null) {
            return "";
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        this.setProperty(key, defaultValue);
        return defaultValue;
    }

    protected boolean getOrCreateBoolean(String key, boolean defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    protected double getOrCreateDouble(String key, double defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected int getOrCreateInt(String key, int defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

