/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import net.mat0u5.pastlife.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0332750;
import net.minecraft.unmapped.C_1567607;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_5385258;
import net.minecraft.unmapped.C_9590849;

public class LivesCommand {
    public static void handleCommand(MinecraftServer server, C_3292284 player, String command, C_1567607 networkHandler) {
        if (command.trim().equalsIgnoreCase("/lives")) {
            int lives = Main.livesManager.getLives((C_9590849)player);
            networkHandler.m_3031403("You have " + lives + " " + (lives == 1 ? "life" : "lives") + ".");
            return;
        }
        if (!server.f_0447091.m_6078293(player.f_4437619)) {
            networkHandler.m_3258329((C_5385258)new C_0332750("\u00a7cYou do not have permission to use this command."));
            return;
        }
        int response = LivesCommand.commandLogic(server, command, (C_1730529)networkHandler);
        if (response != 1) {
            networkHandler.m_3258329((C_5385258)new C_0332750("\u00a7cInvalid usage."));
            networkHandler.m_3031403("Use: /lives <get|set|add|remove> <player> [amount]");
        }
    }

    public static int commandLogic(MinecraftServer server, String command, C_1730529 source) {
        if (!command.startsWith("/lives ")) {
            return -1;
        }
        String[] args = command.split(" ");
        if (args.length < 3) {
            return -1;
        }
        String playerName = args[2];
        C_3292284 serverPlayer = server.f_0447091.m_4343635(playerName);
        if (serverPlayer == null) {
            source.m_3031403("Player not found: " + playerName);
            return 1;
        }
        playerName = serverPlayer.f_4437619;
        if (args.length >= 3 && args[1].equalsIgnoreCase("get")) {
            int lives = Main.livesManager.getLives((C_9590849)serverPlayer);
            source.m_3031403(playerName + " has " + lives + " " + (lives == 1 ? "life" : "lives") + ".");
            return 1;
        }
        if (args.length >= 4) {
            block10: {
                try {
                    int amount = Integer.parseInt(args[3]);
                    if (args[1].equalsIgnoreCase("set")) {
                        Main.livesManager.setLives((C_9590849)serverPlayer, amount);
                        break block10;
                    }
                    if (args[1].equalsIgnoreCase("add")) {
                        Main.livesManager.addLives((C_9590849)serverPlayer, amount);
                        break block10;
                    }
                    if (args[1].equalsIgnoreCase("remove")) {
                        Main.livesManager.addLives((C_9590849)serverPlayer, -amount);
                        break block10;
                    }
                    return -1;
                }
                catch (Exception e) {
                    source.m_3031403("Invalid number format for amount: " + args[3]);
                    return -1;
                }
            }
            int lives = Main.livesManager.getLives((C_9590849)serverPlayer);
            source.m_3031403(playerName + " now has " + lives + " " + (lives == 1 ? "life" : "lives") + ".");
            return 1;
        }
        return -1;
    }
}

