/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.lives;

import java.util.HashMap;
import java.util.Map;
import net.mat0u5.pastlife.lives.ConfigManager;
import net.minecraft.unmapped.C_9590849;

public class LivesManager
extends ConfigManager {
    private Map<String, Integer> livesMap = new HashMap<String, Integer>();

    public LivesManager() {
        super(".", "_pastlife_lives.txt");
    }

    private void saveLives(C_9590849 player, int lives) {
        this.setProperty(player.f_4437619, String.valueOf(lives));
        this.livesMap.put(player.f_4437619, lives);
    }

    private int loadLives(C_9590849 player) {
        int lives = this.getOrCreateInt(player.f_4437619, 6);
        this.livesMap.put(player.f_4437619, lives);
        return lives;
    }

    public int getLives(C_9590849 player) {
        if (this.livesMap.containsKey(player.f_4437619)) {
            return this.livesMap.get(player.f_4437619);
        }
        return this.loadLives(player);
    }

    public void setLives(C_9590849 player, int lives) {
        if (lives < 0) {
            lives = 0;
        }
        this.saveLives(player, lives);
    }

    public void addLives(C_9590849 player, int lives) {
        int currentLives = this.loadLives(player);
        this.setLives(player, currentLives += lives);
    }

    public String getColorCode(C_9590849 player) {
        int lives = this.getLives(player);
        if (lives <= 0) {
            return "\u00a78";
        }
        if (lives == 1) {
            return "\u00a7c";
        }
        if (lives == 2) {
            return "\u00a7e";
        }
        if (lives == 3) {
            return "\u00a7a";
        }
        return "\u00a72";
    }
}

