/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.pastlife.mixin;

import net.mat0u5.pastlife.Main;
import net.mat0u5.pastlife.utils.InventoryStorage;
import net.mat0u5.pastlife.utils.PlayerUtils;
import net.mat0u5.pastlife.utils.WorldBorderManager;
import net.minecraft.unmapped.C_0332750;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_5385258;
import net.minecraft.unmapped.C_7400754;
import net.minecraft.unmapped.C_9590849;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={C_3292284.class})
public class ServerPlayerEntityMixin {
    @Unique
    private C_0539808 lastDamageSource;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        C_3292284 player = (C_3292284)this;
        if (!WorldBorderManager.initialized || player.f_4703454.f_6669533.f_1925911) {
            return;
        }
        double centerX = WorldBorderManager.centerX;
        double centerZ = WorldBorderManager.centerZ;
        if (WorldBorderManager.isOutsideBorder(player.f_6638345, player.f_9103758)) {
            double halfSize = (double)WorldBorderManager.borderSize / 2.0;
            double posX = player.f_6638345;
            double posY = player.f_1187082;
            double posZ = player.f_9103758;
            double newX = posX;
            double newZ = posZ;
            if (Math.abs(posX - centerX) > halfSize) {
                newX = centerX + halfSize * Math.signum(posX - centerX);
            }
            if (Math.abs(posZ - centerZ) > halfSize) {
                newZ = centerZ + halfSize * Math.signum(posZ - centerZ);
            }
            if (newX != posX || newZ != posZ) {
                player.f_2111610.m_7846276(newX, posY, newZ, player.f_7165431, player.f_0243146);
                player.f_7931186 = 0.0;
                player.f_3399559 = 0.0;
            }
        }
    }

    @Inject(method={"onKilled"}, at={@At(value="HEAD")})
    private void onKilled(C_0539808 entity, CallbackInfo ci) {
        String colorCode;
        C_3292284 player = (C_3292284)this;
        String playerName = player.f_4437619;
        if (Main.livesManager != null && (colorCode = Main.livesManager.getColorCode((C_9590849)player)) != null) {
            playerName = colorCode + playerName + "\u00a7r";
        }
        String deathMessage = playerName + " died";
        if (this.lastDamageSource != null && this.lastDamageSource instanceof C_9590849) {
            String killerColorCode;
            C_9590849 killer = (C_9590849)this.lastDamageSource;
            String killerName = killer.f_4437619;
            if (Main.livesManager != null && (killerColorCode = Main.livesManager.getColorCode(killer)) != null) {
                killerName = killerColorCode + killerName + "\u00a7r";
            }
            deathMessage = playerName + " was slain by " + killerName;
        }
        PlayerUtils.sendPacketToAllPlayers((C_5385258)new C_0332750(deathMessage));
        if (Main.livesManager != null) {
            Main.livesManager.addLives((C_9590849)player, -1);
        }
        if (Main.livesManager != null && Main.livesManager.getLives((C_9590849)player) > 0) {
            InventoryStorage.storeInventory(player.f_4437619, player.f_3923819);
        }
    }

    @Redirect(method={"onKilled"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V"))
    private void keepInventory(C_7400754 instance) {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void restoreInventoryOnSpawn(CallbackInfo ci) {
        C_3292284 player = (C_3292284)this;
        String playerName = player.f_4437619;
        if (InventoryStorage.hasStoredInventory(playerName) && Main.livesManager != null && Main.livesManager.getLives((C_9590849)player) > 0) {
            InventoryStorage.restoreInventory(playerName, player.f_3923819);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void onKilled(C_0539808 entity, int i, CallbackInfoReturnable<Boolean> cir) {
        this.lastDamageSource = entity;
    }
}

