/*
 * Decompiled with CFR 0.152.
 */
package io.github.KevinMoonglow.lunar_origins.item;

import io.github.KevinMoonglow.lunar_origins.Lunar_origins;
import io.github.apace100.apoli.util.PowerGrantingItem;
import io.github.apace100.apoli.util.StackPowerUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassBowl
extends class_1738
implements PowerGrantingItem {
    public static final long MAX_WATER = 81000L;
    public static final int EYE_LEVEL = 48600;
    public static final int BASE_DRAIN_PER_TICK = 6;
    public static final int CRACK_LOSS_AMOUNT = 2;
    public static final int BREATHE_LEVEL = 20;
    public static final int FISHBOWL_LEVEL = 16200;
    public static final float VIEW_LOOK_MIN_DELTA = 0.008f;
    public static final int MAX_SEALANT = 72000;
    public final int[] SEALANT_DRAIN_STEPS;
    public static final SingleFluidStorage fluidStorage = new SingleFluidStorage(){

        protected long getCapacity(FluidVariant variant) {
            if (variant.equals(FluidVariant.of((class_3611)class_3612.field_15910))) {
                return 81000L;
            }
            return 0L;
        }

        public void writeNbt(class_2487 nbt) {
            nbt.method_10544("waterLevel", this.amount);
        }

        public void readNbt(class_2487 nbt) {
            this.amount = nbt.method_10537("waterLevel");
            this.variant = this.amount >= 0L ? FluidVariant.of((class_3611)class_3612.field_15910) : FluidVariant.blank();
        }

        public long getAmount() {
            return super.getAmount();
        }

        public FluidVariant getResource() {
            return (FluidVariant)super.getResource();
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
        }
    };
    protected String FULL_KEY = "item.lunar_origins.glass_bowl.full";
    private final List<StackPowerUtil.StackPower> POWERS = new LinkedList<StackPowerUtil.StackPower>();

    public GlassBowl(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings, int[] sealantDrainSteps) {
        super(material, type, settings);
        StackPowerUtil.StackPower blockFoodPower = new StackPowerUtil.StackPower();
        blockFoodPower.powerId = new class_2960(Lunar_origins.MOD_ID, "glass_bowl_blocks_food");
        blockFoodPower.slot = class_1304.field_6169;
        blockFoodPower.isHidden = true;
        blockFoodPower.isNegative = false;
        this.POWERS.add(blockFoodPower);
        StackPowerUtil.StackPower nightVisionGogglesPower = new StackPowerUtil.StackPower();
        nightVisionGogglesPower.powerId = new class_2960(Lunar_origins.MOD_ID, "night_vision_for_goggles");
        nightVisionGogglesPower.slot = class_1304.field_6169;
        nightVisionGogglesPower.isHidden = true;
        nightVisionGogglesPower.isNegative = false;
        this.POWERS.add(nightVisionGogglesPower);
        this.SEALANT_DRAIN_STEPS = sealantDrainSteps;
    }

    public String getFullKey() {
        return this.FULL_KEY;
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 nbt = stack.method_7969();
            assert (nbt != null);
            long waterLevel = nbt.method_10537("waterLevel");
            if (waterLevel >= 16200L) {
                return class_2561.method_43471((String)this.getFullKey());
            }
        }
        return super.method_7864(stack);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
        class_3965 hitResult;
        class_1799 itemStack = playerEntity.method_5998(hand);
        long waterLevel = 0L;
        if (itemStack.method_7985()) {
            assert (itemStack.method_7969() != null);
            waterLevel = itemStack.method_7969().method_10537("waterLevel");
        }
        if ((hitResult = GlassBowl.method_7872((class_1937)world, (class_1657)playerEntity, (class_3959.class_242)(waterLevel < 81000L ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348))).method_17783() == class_239.class_240.field_1332 && waterLevel < 81000L) {
            class_2338 blockPos = hitResult.method_17777();
            if (!world.method_8505(playerEntity, blockPos)) {
                return class_1271.method_22430((Object)itemStack);
            }
            if (world.method_8316(blockPos).method_15767(class_3486.field_15517)) {
                class_2263 fluidBlock;
                class_1799 s;
                class_2680 state = world.method_8320(blockPos);
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof class_2263 && !(s = (fluidBlock = (class_2263)class_22482).method_9700((class_1936)world, blockPos, state)).method_7960()) {
                    world.method_43128(playerEntity, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15126, class_3419.field_15254, 1.0f, 1.0f);
                    world.method_33596((class_1297)playerEntity, class_5712.field_28167, blockPos);
                }
                return class_1271.method_29237((Object)this.fill(itemStack, playerEntity), (boolean)world.method_8608());
            }
        }
        return super.method_7836(world, playerEntity, hand);
    }

    protected class_1799 fill(@NotNull class_1799 stack, @NotNull class_1657 player) {
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        class_2487 nbt = stack.method_7948();
        nbt.method_10544("waterLevel", 81000L);
        nbt.method_10556("waterEyeLevel", true);
        nbt.method_10556("hasWater", true);
        return stack;
    }

    public boolean isCracked(class_1799 stack) {
        return (double)((float)stack.method_7919() / (float)stack.method_7936()) >= 0.5;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity != null && entity.method_5709() && slot == class_1304.field_6169.method_5927()) {
            class_1309 p = (class_1309)entity;
            long waterLevel = 0L;
            int sealant = 0;
            boolean superSealant = false;
            class_2487 nbt = null;
            class_1799 headStack = p.method_6118(class_1304.field_6169);
            if (stack.method_7985()) {
                nbt = stack.method_7969();
                assert (nbt != null);
                waterLevel = nbt.method_10537("waterLevel");
                sealant = nbt.method_10550("bowlSealant");
                superSealant = nbt.method_10577("bowlSuperSealant");
            } else if (entity.method_5869() && headStack == stack) {
                nbt = new class_2487();
                stack.method_7980(nbt);
            }
            if (headStack == stack && nbt != null) {
                float viewLevelP;
                float sealantPercent = (float)sealant / 72000.0f;
                int sealantLossStep = (int)Math.ceil(sealantPercent * (float)(this.SEALANT_DRAIN_STEPS.length - 1));
                int sealantLossAmount = superSealant ? 0 : this.SEALANT_DRAIN_STEPS[sealantLossStep];
                boolean cracked = this.isCracked(stack);
                if (!p.method_5869()) {
                    if (waterLevel > 0L) {
                        if (sealant > 0 && !superSealant) {
                            nbt.method_10569("bowlSealant", --sealant);
                        }
                        waterLevel -= cracked ? 12L : 0L;
                        if ((waterLevel -= 6L * (long)sealantLossAmount) < 0L) {
                            waterLevel = 0L;
                        }
                        nbt.method_10544("waterLevel", waterLevel);
                        nbt.method_10556("hasWater", waterLevel > 0L);
                    }
                } else if (waterLevel < 81000L) {
                    if (sealant > 0 && !superSealant) {
                        nbt.method_10569("bowlSealant", --sealant);
                    }
                    waterLevel += cracked ? 12L : 0L;
                    if ((waterLevel += 6L * (long)sealantLossAmount) > 81000L) {
                        waterLevel = 81000L;
                    }
                    nbt.method_10544("waterLevel", waterLevel);
                    nbt.method_10556("hasWater", waterLevel > 0L);
                }
                float viewWaterScaling = (viewLevelP = entity.method_36455() / 90.0f) >= 0.0f ? viewLevelP * 2.0f + 1.0f : viewLevelP * 2.0f - 1.0f;
                float waterLevelP = (float)waterLevel / 81000.0f;
                float eyeLevelP = 0.6f;
                float waterLevelAdjusted = viewWaterScaling > 0.0f ? waterLevelP * viewWaterScaling : 1.0f - (1.0f - waterLevelP) * -viewWaterScaling;
                float waterDiff = waterLevelAdjusted - eyeLevelP;
                float waterDiffScaled = waterDiff > 0.0f ? waterDiff / (1.0f - eyeLevelP) : waterDiff / eyeLevelP;
                nbt.method_10548("waterViewHeight", waterDiffScaled);
                if (waterDiff > -0.008f) {
                    nbt.method_10556("waterEyeLevel", true);
                } else if (waterDiff < 0.008f) {
                    nbt.method_10556("waterEyeLevel", false);
                }
            }
        }
    }

    public Collection<StackPowerUtil.StackPower> getPowers(class_1799 stack, class_1304 slot) {
        return this.POWERS.stream().filter(p -> p.slot == slot).toList();
    }

    public boolean applySealant(class_1799 stack, int amount) {
        class_2487 nbt = stack.method_7948();
        int sealant = nbt.method_10550("bowlSealant");
        boolean superSealant = nbt.method_10577("bowlSuperSealant");
        if (sealant >= 72000 || superSealant) {
            return false;
        }
        if ((sealant += amount) > 72000) {
            sealant = 72000;
        }
        nbt.method_10569("bowlSealant", sealant);
        return true;
    }

    public boolean applySuperSealant(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        boolean superSealant = nbt.method_10577("bowlSuperSealant");
        if (superSealant) {
            return false;
        }
        nbt.method_10569("bowlSealant", 72000);
        nbt.method_10556("bowlSuperSealant", true);
        return true;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            if (nbt.method_10577("bowlSuperSealant")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lunar_origins.glass_bowl.tooltip.super_seal").method_27692(class_124.field_1080));
            } else if (nbt.method_10550("bowlSealant") > 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lunar_origins.glass_bowl.tooltip.seal").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lunar_origins.glass_bowl.tooltip.no_seal").method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lunar_origins.glass_bowl.tooltip.no_seal").method_27692(class_124.field_1080));
        }
        if (nbt != null) {
            boolean superSealant = nbt.method_10577("bowlSuperSealant");
            int sealant = nbt.method_10550("bowlSealant");
            int segments = (int)Math.floor((float)sealant / 72000.0f * 5.0f);
            String s = "\u2588".repeat(segments) + "\u2591".repeat(5 - segments);
            class_5250 t = class_2561.method_43470((String)s);
            t = sealant <= 0 ? t.method_27692(class_124.field_1063) : (superSealant ? t.method_27692(class_124.field_1054) : t.method_27692(class_124.field_1060));
            tooltip.add((class_2561)t);
        }
    }

    private void putWaterLevel(@Nullable class_2487 nbt, @NotNull class_1799 stack, long newWater) {
        if (nbt == null) {
            nbt = new class_2487();
            stack.method_7980(nbt);
        }
        nbt.method_10544("waterLevel", newWater);
        nbt.method_10556("hasWater", newWater > 0L);
    }

    private long pourToBowlStack(@NotNull class_1799 source, @Nullable class_2487 sourceNbt, @NotNull class_1799 target, @Nullable class_2487 targetNbt, @Nullable Long maxAmount) {
        long sourceWaterLevel = sourceNbt != null ? sourceNbt.method_10537("waterLevel") : 0L;
        long targetWaterLevel = targetNbt != null ? targetNbt.method_10537("waterLevel") : 0L;
        long maxTransfer = Math.max(81000L - targetWaterLevel, 0L);
        long fullTransfer = Math.min(maxTransfer, sourceWaterLevel);
        long actualTransfer = maxAmount != null ? Math.min(maxAmount, fullTransfer) : fullTransfer;
        this.putWaterLevel(sourceNbt, source, sourceWaterLevel - actualTransfer);
        this.putWaterLevel(targetNbt, target, targetWaterLevel + actualTransfer);
        return actualTransfer;
    }

    private long pourToBowlStack(@NotNull class_1799 source, @Nullable class_2487 sourceNbt, @NotNull class_1799 target, @Nullable class_2487 targetNbt) {
        return this.pourToBowlStack(source, sourceNbt, target, targetNbt, null);
    }

    private boolean pourToContainer(class_1799 bowl, class_1799 container, class_1657 player, Object targetSlot, class_1792 containerItemType, class_1792 filledItemType, long amount) {
        class_2487 nbt = bowl.method_7969();
        long waterLevel = nbt != null ? nbt.method_10537("waterLevel") : 0L;
        class_1792 containerItem = container.method_7909();
        if (containerItem == containerItemType) {
            if (waterLevel < amount) {
                return true;
            }
            class_1799 newContainer = new class_1799((class_1935)filledItemType);
            if (filledItemType instanceof class_1812) {
                class_1844.method_8061((class_1799)newContainer, (class_1842)class_1847.field_8991);
            }
            container.method_7934(1);
            if (container.method_7947() <= 0) {
                if (targetSlot instanceof class_1735) {
                    ((class_1735)targetSlot).method_48931(newContainer);
                } else if (targetSlot instanceof class_5630) {
                    ((class_5630)targetSlot).method_32332(newContainer);
                } else assert (false);
            } else if (!player.method_31548().method_7394(newContainer)) {
                player.method_7328(newContainer, false);
            }
            this.putWaterLevel(nbt, bowl, waterLevel - amount);
            return true;
        }
        return false;
    }

    private boolean pourFromContainer(class_1799 bowl, class_1799 container, class_1657 player, Object sourceSlot, class_1792 containerItemType, class_1792 filledItemType, long amount) {
        class_2487 nbt = bowl.method_7969();
        long waterLevel = nbt != null ? nbt.method_10537("waterLevel") : 0L;
        class_1792 containerItem = container.method_7909();
        if (containerItem == filledItemType) {
            if (waterLevel + amount > 81000L) {
                return true;
            }
            if (filledItemType instanceof class_1812 && class_1844.method_8063((class_1799)container) != class_1847.field_8991) {
                return false;
            }
            if (sourceSlot instanceof class_1735) {
                ((class_1735)sourceSlot).method_48931(new class_1799((class_1935)containerItemType));
            } else if (sourceSlot instanceof class_5630) {
                ((class_5630)sourceSlot).method_32332(new class_1799((class_1935)containerItemType));
            } else assert (false);
            this.putWaterLevel(nbt, bowl, waterLevel + amount);
            return true;
        }
        return false;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            long waterLevel;
            class_1799 target = slot.method_7677();
            class_1792 targetItem = target.method_7909();
            class_2487 nbt = stack.method_7969();
            long l = waterLevel = nbt != null ? nbt.method_10537("waterLevel") : 0L;
            if (this.pourToContainer(stack, target, player, slot, class_1802.field_8469, class_1802.field_8574, 27000L)) {
                return true;
            }
            if (this.pourFromContainer(stack, target, player, slot, class_1802.field_8469, class_1802.field_8574, 27000L)) {
                return true;
            }
            if (this.pourToContainer(stack, target, player, slot, class_1802.field_8550, class_1802.field_8705, 81000L)) {
                return true;
            }
            if (this.pourFromContainer(stack, target, player, slot, class_1802.field_8550, class_1802.field_8705, 81000L)) {
                return true;
            }
            if (targetItem instanceof GlassBowl) {
                class_1799 headGear = player.method_6118(class_1304.field_6169);
                if (headGear == target) {
                    return true;
                }
                class_2487 targetNbt = target.method_7969();
                if (waterLevel > 0L) {
                    this.pourToBowlStack(stack, nbt, target, targetNbt);
                } else {
                    this.pourToBowlStack(target, targetNbt, stack, nbt);
                }
                return true;
            }
        }
        return super.method_31565(stack, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            class_1799 headGear = player.method_6118(class_1304.field_6169);
            if (headGear == stack) {
                return true;
            }
            if (this.pourToContainer(stack, otherStack, player, cursorStackReference, class_1802.field_8469, class_1802.field_8574, 27000L)) {
                return true;
            }
            if (this.pourFromContainer(stack, otherStack, player, cursorStackReference, class_1802.field_8469, class_1802.field_8574, 27000L)) {
                return true;
            }
            if (this.pourToContainer(stack, otherStack, player, cursorStackReference, class_1802.field_8550, class_1802.field_8705, 81000L)) {
                return true;
            }
            if (this.pourFromContainer(stack, otherStack, player, cursorStackReference, class_1802.field_8550, class_1802.field_8705, 81000L)) {
                return true;
            }
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }
}

