/*
 * Decompiled with CFR 0.152.
 */
package io.github.KevinMoonglow.lunar_origins.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.KevinMoonglow.lunar_origins.Lunar_origins;
import io.github.KevinMoonglow.lunar_origins.item.AmethystGlassBowl;
import io.github.KevinMoonglow.lunar_origins.item.DivingHelmet;
import io.github.KevinMoonglow.lunar_origins.item.GlassBowl;
import io.github.KevinMoonglow.lunar_origins.item.Goggles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
@Environment(value=EnvType.CLIENT)
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    private int field_2011;
    @Shadow
    private int field_2029;
    @Unique
    class_2960 WATER_TEXTURE = new class_2960("textures/misc/underwater.png");
    @Unique
    final class_2960 AIR_BUBBLE_TEXTURE = new class_2960(Lunar_origins.MOD_ID, "textures/misc/air_bubble_overlay.png");
    @Unique
    final class_2960 GLASS_BOWL_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/glass_bowl_overlay.png");
    @Unique
    final class_2960 GLASS_BOWL_CRACK_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/glass_bowl_crack_overlay.png");
    @Unique
    final class_2960 AMETHYST_BOWL_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/amethyst_bowl_overlay.png");
    @Unique
    final class_2960 DIVING_HELMET_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/diving_helmet_overlay.png");
    @Unique
    final class_2960 AMETHYST_BOWL_CRACK_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/amethyst_bowl_crack_overlay.png");
    @Unique
    final class_2960 GOGGLES_OVERLAY = new class_2960(Lunar_origins.MOD_ID, "textures/misc/goggle_overlay.png");

    @Invoker(value="renderOverlay")
    abstract void invokeRenderOverlay(class_332 var1, class_2960 var2, float var3);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;getFrozenTicks()I", ordinal=0)})
    private void renderOnHud(class_332 context, float tickDelta, CallbackInfo ci) {
        class_1297 viewer = this.field_2035.method_1560();
        if (viewer != null && viewer.method_5709() && this.field_2035.field_1690.method_31044().method_31034()) {
            class_1309 entity = (class_1309)viewer;
            class_1799 head = entity.method_6118(class_1304.field_6169);
            class_1792 item = head.method_7909();
            if (item instanceof GlassBowl) {
                class_2487 nbt = head.method_7969();
                if (nbt != null) {
                    long waterLevel = nbt.method_10537("waterLevel");
                    float level = InGameHudMixin.getLevel(entity, waterLevel);
                    if (item instanceof DivingHelmet) {
                        this.invokeRenderOverlay(context, this.DIVING_HELMET_OVERLAY, 1.0f);
                    } else if (item instanceof AmethystGlassBowl) {
                        this.invokeRenderOverlay(context, this.AMETHYST_BOWL_OVERLAY, 0.75f);
                    } else {
                        this.invokeRenderOverlay(context, this.GLASS_BOWL_OVERLAY, 0.75f);
                    }
                    if ((float)head.method_7919() / (float)head.method_7936() >= 0.5f && !(item instanceof DivingHelmet)) {
                        if (item instanceof AmethystGlassBowl) {
                            this.invokeRenderOverlay(context, this.AMETHYST_BOWL_CRACK_OVERLAY, 0.75f);
                        } else {
                            this.invokeRenderOverlay(context, this.GLASS_BOWL_CRACK_OVERLAY, 0.75f);
                        }
                    }
                    if (entity.method_5777(class_3486.field_15517)) {
                        this.renderAir(level);
                    } else {
                        this.renderWater(level);
                    }
                }
            } else if (item instanceof Goggles) {
                this.invokeRenderOverlay(context, this.GOGGLES_OVERLAY, 1.0f);
            }
        }
    }

    @Unique
    private static float getLevel(class_1309 entity, float waterLevel) {
        float viewLevelPitch = entity.method_36455() / 90.0f;
        float viewWaterScaling = viewLevelPitch >= 0.0f ? viewLevelPitch * 2.0f + 1.0f : viewLevelPitch * 2.0f - 1.0f;
        float waterLevelP = waterLevel / 81000.0f;
        float eyeLevelP = 0.6f;
        float waterLevelAdjusted = viewWaterScaling > 0.0f ? waterLevelP * viewWaterScaling : 1.0f - (1.0f - waterLevelP) * -viewWaterScaling;
        float waterDiff = waterLevelAdjusted - eyeLevelP;
        return waterDiff > 0.0f ? waterDiff / (1.0f - eyeLevelP) : waterDiff / eyeLevelP;
    }

    @Unique
    private void renderWater(float level) {
        level *= 0.5f;
        level += 0.5f;
        level = Math.min(level, 1.0f);
        level = Math.max(level, 0.0f);
        double waterHeight = (float)this.field_2029 * level;
        double waterTop = (double)this.field_2029 - waterHeight;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.WATER_TEXTURE);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(0.0, (double)this.field_2029, -91.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_2011, (double)this.field_2029, -91.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_2011, waterTop, -91.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(0.0, waterTop, -91.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Unique
    private void renderAir(float level) {
        level *= 0.5f;
        level += 0.5f;
        level = Math.min(level, 1.0f);
        level = Math.max(level, 0.0f);
        double waterHeight = (float)this.field_2029 * level;
        double waterTop = (double)this.field_2029 - waterHeight;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.AIR_BUBBLE_TEXTURE);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(0.0, waterTop, -91.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_2011, waterTop, -91.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_2011, 0.0, -91.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, -91.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

