/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.mal32.endergames.bukkit.Metrics;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.lobby.LobbyWorld;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EnderGames
extends JavaPlugin
implements Listener {
    private static final NamespacedKey playerWorldKey = new NamespacedKey("endergames", "world");
    private GameWorld gameWorld;
    private LobbyWorld lobbyWorld;

    public static boolean playerIsInLobbyWorld(Player player) {
        String world = (String)player.getPersistentDataContainer().get(playerWorldKey, PersistentDataType.STRING);
        return Objects.equals(world, "lobby");
    }

    public static boolean playerIsInGameWorld(Player player) {
        String world = (String)player.getPersistentDataContainer().get(playerWorldKey, PersistentDataType.STRING);
        return Objects.equals(world, "game");
    }

    public void onEnable() {
        int PLUGIN_ID = 25844;
        Metrics metrics = new Metrics(this, 25844);
        if (EnderGames.isInDebugMode()) {
            this.getComponentLogger().warn("Debug mode is enabled.");
        }
        this.gameWorld = new GameWorld(this);
        this.lobbyWorld = new LobbyWorld(this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(this.endergamesCommand()));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public GameWorld getGameWorld() {
        return this.gameWorld;
    }

    public void teleportPlayerToGame(Player player) {
        player.getPersistentDataContainer().set(playerWorldKey, PersistentDataType.STRING, (Object)"game");
        this.gameWorld.initPlayer(player);
    }

    public void teleportPlayerToLobby(Player player) {
        player.getPersistentDataContainer().set(playerWorldKey, PersistentDataType.STRING, (Object)"lobby");
        this.lobbyWorld.initPlayer(player);
    }

    private LiteralCommandNode<CommandSourceStack> endergamesCommand() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"endergames").then(((LiteralArgumentBuilder)Commands.literal((String)"start").requires(sender -> sender.getSender().isOp())).executes(ctx -> {
            this.gameWorld.startGame();
            return 1;
        }))).build();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.teleportPlayerToLobby(event.getPlayer());
    }

    public static boolean isInDebugMode() {
        String debugEnv = System.getenv("EG_DEBUG");
        return debugEnv != null && (debugEnv.equalsIgnoreCase("true") || debugEnv.equalsIgnoreCase("1"));
    }
}

