/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.Barbarian;
import io.github.mal32.endergames.kits.Bird;
import io.github.mal32.endergames.kits.Blaze;
import io.github.mal32.endergames.kits.Bomber;
import io.github.mal32.endergames.kits.Cactus;
import io.github.mal32.endergames.kits.Cat;
import io.github.mal32.endergames.kits.Dolphin;
import io.github.mal32.endergames.kits.Enderman;
import io.github.mal32.endergames.kits.Kangaroo;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.kits.Lucker;
import io.github.mal32.endergames.kits.Lumberjack;
import io.github.mal32.endergames.kits.Mace;
import io.github.mal32.endergames.kits.Rewind;
import io.github.mal32.endergames.kits.Slime;
import io.github.mal32.endergames.kits.Spectator;
import io.github.mal32.endergames.kits.Voodoo;
import io.github.mal32.endergames.worlds.game.GameWorld;
import java.util.List;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class AbstractKit
extends AbstractModule {
    public AbstractKit(EnderGames plugin) {
        super(plugin);
    }

    public static List<AbstractKit> getKits(EnderGames plugin) {
        return List.of(new Lumberjack(plugin), new Cat(plugin), new Cactus(plugin), new Barbarian(plugin), new Blaze(plugin), new Slime(plugin), new Dolphin(plugin), new Mace(plugin), new Bird(plugin), new Bomber(plugin), new Kangaroo(plugin), new Enderman(plugin), new Lucker(plugin), new Rewind(plugin), new Voodoo(plugin), new Spectator(plugin));
    }

    protected static ItemStack enchantItem(ItemStack item, Enchantment enchantment, int level) {
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(enchantment, level, true);
        item.setItemMeta(meta);
        return item;
    }

    protected static ItemStack colorLeatherArmor(ItemStack item, Color color) {
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        meta.setColor(color);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    protected boolean playerCanUseThisKit(Player player) {
        boolean playerInGame = GameWorld.playerIsInGame(player);
        boolean playerHasKit = Objects.equals(player.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "kit"), PersistentDataType.STRING), this.getNameLowercase());
        return playerHasKit && playerInGame;
    }

    public abstract void start(Player var1);

    public String getNameLowercase() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public abstract KitDescription getDescription();
}

