/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class Barbarian
extends AbstractKit {
    public Barbarian(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setHelmet(Barbarian.enchantItem(new ItemStack(Material.LEATHER_HELMET), Enchantment.UNBREAKING, 1));
        player.getInventory().setChestplate(Barbarian.enchantItem(new ItemStack(Material.LEATHER_CHESTPLATE), Enchantment.UNBREAKING, 1));
        player.getInventory().setLeggings(Barbarian.enchantItem(new ItemStack(Material.LEATHER_LEGGINGS), Enchantment.UNBREAKING, 1));
        player.getInventory().setBoots(Barbarian.enchantItem(new ItemStack(Material.LEATHER_BOOTS), Enchantment.UNBREAKING, 1));
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WOODEN_SWORD)});
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player) || !this.playerCanUseThisKit(damager = (Player)entity)) {
            return;
        }
        if (!Tag.ITEMS_SWORDS.isTagged((Keyed)damager.getInventory().getItemInMainHand().getType())) {
            return;
        }
        int foodLevel = damager.getFoodLevel();
        int maxFoodLevel = 20;
        double damageMultiplier = 1.0 + (double)(20 - foodLevel) * 0.025;
        event.setDamage(event.getDamage() * damageMultiplier);
        if (damageMultiplier > 1.3) {
            Location location = event.getEntity().getLocation();
            location.getWorld().playSound(location, Sound.BLOCK_MANGROVE_ROOTS_BREAK, 1.0f, 0.5f);
            location.getWorld().spawnParticle(Particle.HEART, location.clone().add(0.0, 1.0, 0.0), 10, 0.2, 0.6, 0.2, 2.0);
        }
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.LEATHER_CHESTPLATE, "Barbarian", "Deals more attack damage with swords the hungrier he is (+2.5% attack damage per half hunger bar missing)", "A wooden sword and a full set of leather armor with Unbreaking I", Difficulty.HARD);
    }
}

