/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class Bird
extends AbstractKit {
    public Bird(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setChestplate(new ItemStack(Material.ELYTRA));
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.FIREWORK_ROCKET, 10)});
    }

    @EventHandler
    public void onPlayerKill(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player victim = (Player)livingEntity;
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        if (!this.playerCanUseThisKit(killer)) {
            return;
        }
        killer.getInventory().addItem(new ItemStack[]{new ItemStack(Material.FIREWORK_ROCKET, 5)});
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        player.getInventory().remove(Material.ELYTRA);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.ELYTRA, "Bird", "Starts with an Elytra and 10 Rockets. Gains 5 rockets per player kill. Fly like a bird!", "1 Elytra, 5 Firework Rockets", Difficulty.MEDIUM);
    }
}

