/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Blaze
extends AbstractKit {
    private final HashMap<UUID, LocalTime> burnTime = new HashMap();

    public Blaze(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        ItemStack blazePowder = new ItemStack(Material.BLAZE_POWDER);
        ItemMeta meta = blazePowder.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Burn").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        blazePowder.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{blazePowder});
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLDEN_SWORD)});
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, -1, 0, true, false, false));
    }

    @EventHandler
    public void onPlayerMoveWater(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        PotionEffect effect = player.getPotionEffect(PotionEffectType.WEAKNESS);
        if (player.isInWater()) {
            if (effect == null) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, -1, 0, true, false));
            }
        } else if (effect != null && effect.getDuration() == -1) {
            player.removePotionEffect(PotionEffectType.WEAKNESS);
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player) || !this.playerCanUseThisKit(damager = (Player)entity)) {
            return;
        }
        if (Math.random() > 0.25) {
            return;
        }
        event.getEntity().setFireTicks(60);
    }

    @EventHandler
    public void onBowShot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (Math.random() > 0.6) {
            return;
        }
        event.getProjectile().setFireTicks(60);
    }

    @EventHandler
    public void onPowderClick(PlayerInteractEvent event) {
        int useCooldownSeconds = 30;
        int burnDurationSeconds = 10;
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.BLAZE_POWDER) {
            return;
        }
        if (player.hasCooldown(Material.BLAZE_POWDER)) {
            return;
        }
        this.burnTime.put(player.getUniqueId(), LocalTime.now().plusSeconds(10L));
        player.setCooldown(Material.BLAZE_POWDER, 600);
        Location location = event.getPlayer().getLocation();
        location.getWorld().playSound(location, Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
        location.getWorld().spawnParticle(Particle.FLAME, location.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
    }

    @EventHandler
    public void onPlayerMoveFire(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (!this.burnTime.containsKey(player.getUniqueId())) {
            return;
        }
        if (this.burnTime.get(player.getUniqueId()).isBefore(LocalTime.now())) {
            return;
        }
        player.getLocation().getBlock().setType(Material.FIRE);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.BLAZE_POWDER, "Blaze", "Can leave a fire trail for a short time. It is immune to fire damage, but gains Weakness I in water. Sword or Bow hits have a 20% chance to ignite enemies", "Golden Sword and Burn Power", Difficulty.EASY);
    }
}

