/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.worlds.game.GameWorld;
import java.util.HashSet;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Bomber
extends AbstractKit {
    private final NamespacedKey isMineItemKey;
    private final HashSet<String> mineLocations;

    public Bomber(EnderGames plugin) {
        super(plugin);
        this.isMineItemKey = new NamespacedKey((Plugin)this.plugin, "isMineItem");
        this.mineLocations = new HashSet();
    }

    @Override
    public void start(Player player) {
        ItemStack tntStack = new ItemStack(Material.TNT, 5);
        player.getInventory().addItem(new ItemStack[]{tntStack});
        ItemStack mineStack = new ItemStack(Material.STONE_BUTTON, 10);
        ItemMeta meta = mineStack.getItemMeta();
        meta.itemName((Component)Component.text((String)"Mine"));
        meta.setRarity(ItemRarity.RARE);
        meta.getPersistentDataContainer().set(this.isMineItemKey, PersistentDataType.BOOLEAN, (Object)true);
        mineStack.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{mineStack});
    }

    @EventHandler
    private void onExplosionDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            event.setDamage(0.0);
        }
    }

    @EventHandler
    private void onEntityDeath(EntityDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer == null || !this.playerCanUseThisKit(killer)) {
            return;
        }
        Location location = event.getEntity().getLocation();
        location.createExplosion((Entity)killer, 4.0f, false, true);
    }

    @EventHandler
    private void onMinePlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() != Material.STONE_BUTTON) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Boolean isMineItem = (Boolean)item.getItemMeta().getPersistentDataContainer().get(this.isMineItemKey, PersistentDataType.BOOLEAN);
        if (isMineItem == null || !isMineItem.booleanValue()) {
            return;
        }
        Location blockLocation = event.getBlockPlaced().getLocation();
        String key = blockLocation.getBlockX() + "," + blockLocation.getBlockY() + "," + blockLocation.getBlockZ();
        this.mineLocations.add(key);
        blockLocation.getWorld().playSound(blockLocation, Sound.BLOCK_VAULT_ACTIVATE, 1.0f, 1.0f);
        blockLocation.getWorld().spawnParticle(Particle.SMOKE, blockLocation.clone().add(0.5, 0.0, 0.5), 5, 0.1, 0.1, 0.1, 0.0);
    }

    @EventHandler
    private void onStepOnMine(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        if (!GameWorld.playerIsInGame(event.getPlayer())) {
            return;
        }
        Location blockLocation = event.getTo().getBlock().getLocation();
        String key = blockLocation.getBlockX() + "," + blockLocation.getBlockY() + "," + blockLocation.getBlockZ();
        if (!this.mineLocations.contains(key)) {
            return;
        }
        event.getTo().getBlock().setType(Material.AIR);
        event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 10, 2));
        this.mineLocations.remove(key);
        blockLocation.createExplosion(4.0f, true, true);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.TNT, "Bomber", "Takes no explosion damage. Killed entities explode. TNT placed explodes faster.", "5 TNT, 10 Mines", Difficulty.MEDIUM);
    }
}

