/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.kits.PlayerInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class Cactus
extends AbstractKit {
    private final HashMap<UUID, ArrayList<BlockDisplay>> cactusPlayerMapping = new HashMap();
    private final HashSet<UUID> cactusPlayers = new HashSet();
    private final HashMap<UUID, PlayerInventory> cactusPlayerInventory = new HashMap();

    public Cactus(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setLeggings(Cactus.colorLeatherArmor(new ItemStack(Material.LEATHER_LEGGINGS), Color.fromRGB((int)3064446)));
        player.getInventory().setBoots(Cactus.colorLeatherArmor(new ItemStack(Material.LEATHER_BOOTS), Color.fromRGB((int)3064446)));
    }

    @EventHandler
    public void onCactusHit(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity;
        block6: {
            block5: {
                entity = event.getEntity();
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                entity = event.getDamager();
                if (entity instanceof Damageable) break block6;
            }
            return;
        }
        Damageable damager = (Damageable)entity;
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (this.cactusPlayers.contains(player.getUniqueId())) {
            this.leaveCactus(player);
            player.setSneaking(false);
        }
        Location location = player.getLocation();
        location.getWorld().playSound(location, Sound.ENCHANT_THORNS_HIT, 1.0f, 1.0f);
        int damage = 3 + (int)Math.round(Math.random() * 4.0);
        damager.damage((double)damage, (Entity)player);
    }

    @EventHandler
    public void cancelCactusAttacks(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        if (this.playerCanUseThisKit(attacker) && this.cactusPlayers.contains(attacker.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (event.isSneaking() && !this.cactusPlayers.contains(player.getUniqueId())) {
            boolean currentBlockEmpty = player.getLocation().clone().add(0.0, 0.5, 0.0).getBlock().isPassable();
            boolean standingBlockSolid = player.getLocation().clone().add(0.0, -0.5, 0.0).getBlock().isSolid();
            if (currentBlockEmpty && standingBlockSolid) {
                this.enterCactus(player);
            }
            return;
        }
        if (!event.isSneaking() && this.cactusPlayers.contains(player.getUniqueId())) {
            this.leaveCactus(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.playerCanUseThisKit(player) && this.cactusPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (this.playerCanUseThisKit(player) && this.cactusPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.playerCanUseThisKit(player) && this.cactusPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.playerCanUseThisKit(player) && this.cactusPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource shooter = event.getEntity().getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        if (this.playerCanUseThisKit(player) && this.cactusPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (!this.cactusPlayers.contains(uuid)) {
            return;
        }
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            player.getInventory().setHeldItemSlot(event.getPreviousSlot());
            player.updateInventory();
        });
    }

    private void enterCactus(Player player) {
        UUID uuid = player.getUniqueId();
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 0, false, false, false));
        player.playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
        ItemStack[] hotbar = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            hotbar[i] = player.getInventory().getItem(i);
        }
        PlayerInventory inventory = new PlayerInventory(player.getInventory().getArmorContents(), hotbar, player.getInventory().getItemInOffHand());
        this.cactusPlayerInventory.put(uuid, inventory);
        ItemStack cactusBlock = new ItemStack(Material.CACTUS);
        for (int i = 0; i < 9; ++i) {
            player.getInventory().setItem(i, cactusBlock);
        }
        player.getInventory().setItemInOffHand(null);
        player.getInventory().setItemInMainHand(null);
        player.getInventory().setHelmet(null);
        player.getInventory().setChestplate(cactusBlock);
        player.getInventory().setLeggings(cactusBlock);
        player.getInventory().setBoots(cactusBlock);
        this.cactusPlayers.add(uuid);
        if (!this.cactusPlayerMapping.containsKey(uuid)) {
            this.cactusPlayerMapping.put(uuid, new ArrayList());
        }
        Location blockLocation = player.getLocation().getBlock().getLocation();
        World world = player.getWorld();
        for (int i = 0; i < 3; ++i) {
            Location relativeLocation = blockLocation.clone().add(0.0, (double)i, 0.0);
            BlockDisplay blockDisplay = (BlockDisplay)world.spawnEntity(relativeLocation, EntityType.BLOCK_DISPLAY);
            blockDisplay.setBlock(Material.CACTUS.createBlockData());
            this.cactusPlayerMapping.get(uuid).add(blockDisplay);
        }
    }

    private void leaveCactus(Player player) {
        UUID uuid = player.getUniqueId();
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        PlayerInventory inventory = this.cactusPlayerInventory.get(uuid);
        for (int i = 0; i < 9; ++i) {
            player.getInventory().setItem(i, inventory.hotbar()[i]);
        }
        player.getInventory().setArmorContents(inventory.armor());
        player.getInventory().setItemInOffHand(inventory.offhand());
        ArrayList<BlockDisplay> blocks = this.cactusPlayerMapping.get(uuid);
        if (blocks != null) {
            for (BlockDisplay blockDisplay : blocks) {
                blockDisplay.remove();
            }
            blocks.clear();
        }
        this.cactusPlayers.remove(uuid);
        this.cactusPlayerInventory.remove(uuid);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        this.leaveCactus(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        this.leaveCactus(player);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (!this.cactusPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.leaveCactus(player);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean currentBlockEmpty = player.getLocation().clone().add(0.0, 1.1, 0.0).getBlock().isEmpty();
            boolean standingBlockSolid = player.getLocation().clone().add(0.0, -1.0, 0.0).getBlock().isSolid();
            if (currentBlockEmpty && standingBlockSolid) {
                this.enterCactus(player);
            }
        });
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (!this.cactusPlayers.contains(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.CACTUS, "Cactus", "Deals thorns damage to attackers. It can sneak to disguise itself as a cactus.", "Green leather helmet and leggings", Difficulty.EASY);
    }
}

