/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.worlds.game.game.PotionEffectsStacking;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.FoodProperties;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Cat
extends AbstractKit {
    public Cat(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        ItemStack fish = new ItemStack(Material.COD, 20);
        FoodProperties fishProperties = (FoodProperties)FoodProperties.food().canAlwaysEat(true).nutrition(3).saturation(0.6f).build();
        fish.setData(DataComponentTypes.FOOD, (Object)fishProperties);
        ItemMeta fishMeta = fish.getItemMeta();
        fishMeta.displayName(Component.text((String)"Fish").decoration(TextDecoration.ITALIC, false));
        fishMeta.lore(List.of((TextComponent)Component.text((String)"Can always be eaten").color((TextColor)NamedTextColor.GRAY)));
        fish.setItemMeta(fishMeta);
        player.getInventory().addItem(new ItemStack[]{fish});
        AttributeInstance safeFallDistanceAttribute = player.getAttribute(Attribute.SAFE_FALL_DISTANCE);
        safeFallDistanceAttribute.setBaseValue(5.0);
        AttributeInstance fallDamageMultiplierAttribute = player.getAttribute(Attribute.FALL_DAMAGE_MULTIPLIER);
        fallDamageMultiplierAttribute.setBaseValue(0.5);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        AttributeInstance safeFallDistanceAttribute = player.getAttribute(Attribute.SAFE_FALL_DISTANCE);
        safeFallDistanceAttribute.setBaseValue(safeFallDistanceAttribute.getDefaultValue());
        AttributeInstance fallDamageMultiplierAttribute = player.getAttribute(Attribute.FALL_DAMAGE_MULTIPLIER);
        fallDamageMultiplierAttribute.setBaseValue(fallDamageMultiplierAttribute.getDefaultValue());
    }

    @EventHandler
    private void onPlayerEatFish(PlayerItemConsumeEvent event) {
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        if (!Tag.ITEMS_FISHES.isTagged((Keyed)event.getItem().getType())) {
            return;
        }
        PotionEffectsStacking.addPotionEffect(event.getPlayer(), new PotionEffect(PotionEffectType.SPEED, 600, 2, true));
    }

    @EventHandler
    private void onPlayerHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player) || !this.playerCanUseThisKit(damager = (Player)entity)) {
            return;
        }
        if (!damager.getInventory().getItemInMainHand().getType().isAir()) {
            return;
        }
        event.setDamage(event.getDamage() + 3.0);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.COD, "Cat", "Gains Speed III for 30 seconds when eating raw fish. It deals +3 damage with bare hands and takes 50% less fall damage.", "20 raw fish", Difficulty.EASY);
    }
}

