/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Dolphin
extends AbstractKit {
    public Dolphin(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setLeggings(Dolphin.colorLeatherArmor(new ItemStack(Material.LEATHER_LEGGINGS), Color.fromRGB((int)3507428)));
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WATER_BUCKET)});
        player.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, -1, 0, true, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, -1, 0, true, false));
    }

    @EventHandler
    public void waterEffects(PlayerMoveEvent event) {
        boolean hasResistance;
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        boolean hasRegeneration = player.hasPotionEffect(PotionEffectType.REGENERATION) && player.getPotionEffect(PotionEffectType.REGENERATION).getDuration() == -1;
        boolean hasWeakness = player.hasPotionEffect(PotionEffectType.WEAKNESS) && player.getPotionEffect(PotionEffectType.WEAKNESS).getDuration() == -1;
        boolean bl = hasResistance = player.hasPotionEffect(PotionEffectType.RESISTANCE) && player.getPotionEffect(PotionEffectType.RESISTANCE).getDuration() == -1;
        if (player.isInWater()) {
            if (!hasRegeneration) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, -1, 0, true, false));
            }
            if (!hasResistance) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, -1, 0, true, false));
            }
            if (hasWeakness) {
                player.removePotionEffect(PotionEffectType.WEAKNESS);
            }
        } else {
            if (hasRegeneration) {
                player.removePotionEffect(PotionEffectType.REGENERATION);
            }
            if (hasResistance) {
                player.removePotionEffect(PotionEffectType.RESISTANCE);
            }
            if (!hasWeakness) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, -1, 0, true, false));
            }
        }
    }

    @EventHandler
    public void fishWhenSwimming(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (!player.isSwimming()) {
            return;
        }
        double FISHING_LOOT_PROBABILITY = 0.05;
        if (Math.random() > 0.05) {
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("loot give " + player.getName() + " loot minecraft:gameplay/fishing/fish"));
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.TROPICAL_FISH, "Dolphin", "Has permanent Conduit Power and Dolphins Grace. Gets Regeneration and Resistance in Water. Has Weakness on Land. Swimming gives Fish.", "Water Bucket, Blue Leather Boots", Difficulty.HARD);
    }
}

