/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Enderman
extends AbstractKit {
    public Enderman(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        ItemStack enderPerls = new ItemStack(Material.ENDER_PEARL, 5);
        player.getInventory().addItem(new ItemStack[]{enderPerls});
    }

    @EventHandler
    private void onPlayerKill(PlayerDeathEvent event) {
        Player killer = event.getPlayer().getKiller();
        if (killer == null) {
            return;
        }
        if (!this.playerCanUseThisKit(killer)) {
            return;
        }
        killer.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL, 3)});
    }

    @EventHandler
    private void onEnderPearlDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (event.getDamageSource().getDamageType() != DamageType.ENDER_PEARL) {
            return;
        }
        event.setCancelled(true);
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 10, 4, true, false, false));
    }

    @EventHandler
    private void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        Set<Material> passableBlocks = Set.of(Material.AIR, Material.WATER, Material.SNOW, Material.SHORT_GRASS, Material.TALL_GRASS, Material.SEAGRASS, Material.TALL_SEAGRASS, Material.LEAF_LITTER);
        Block targetBlock = player.getTargetBlock(passableBlocks, 24);
        if (targetBlock.getType() != Material.ENDER_CHEST) {
            return;
        }
        player.playSound((Entity)player, Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
        player.playSound((Entity)player, Sound.BLOCK_ENDER_CHEST_CLOSE, 1.0f, 1.0f);
        PlayerInteractEvent chestOpenEvent = new PlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, null, targetBlock, BlockFace.SELF);
        Bukkit.getServer().getPluginManager().callEvent((Event)chestOpenEvent);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.ENDER_PEARL, "Enderman", "Starts with 5 Ender Pearls. Gain 2 Ender Pearls per player kill. Doesn't take damage from Ender Perls. Can open Ender Chests from further away.", "5 Ender Pearls", Difficulty.EASY);
    }
}

