/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Kangaroo
extends AbstractKit {
    public Kangaroo(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.RABBIT_FOOT, "Kangaroo", "Can double jump at the cost of hunger", null, Difficulty.EASY);
    }

    @Override
    public void start(Player player) {
        player.setAllowFlight(true);
        AttributeInstance attribute = player.getAttribute(Attribute.SAFE_FALL_DISTANCE);
        attribute.setBaseValue(10.0);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        player.setAllowFlight(false);
        AttributeInstance attribute = player.getAttribute(Attribute.SAFE_FALL_DISTANCE);
        attribute.setBaseValue(attribute.getDefaultValue());
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        event.setCancelled(true);
        player.setFlying(false);
        int foodLevel = player.getFoodLevel();
        if (foodLevel < 8) {
            player.sendActionBar(Component.text((String)"At least 4 Food Levels needed").style(Style.style((TextColor)NamedTextColor.YELLOW)));
            return;
        }
        player.setAllowFlight(false);
        Vector jump = player.getLocation().getDirection().multiply(2).setY(1);
        player.setVelocity(jump);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.0f);
        PotionEffect hungerEffect = player.getPotionEffect(PotionEffectType.HUNGER);
        int durationSeconds = 10;
        int startHungerLoss = 4;
        int hungerLossExponent = 3;
        if (hungerEffect == null) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 16, true, true));
            return;
        }
        int hungerAmplifier = hungerEffect.getAmplifier();
        player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, hungerAmplifier * 3, true, true));
    }

    @EventHandler
    public void onPlayerLand(PlayerMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (player.getLocation().clone().add(0.0, -0.1, 0.0).getBlock().isPassable()) {
            return;
        }
        player.setAllowFlight(true);
    }
}

