/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Lucker
extends AbstractKit {
    private final Random random = new Random();
    private static final Set<Material> SEEDS = EnumSet.of(Material.WHEAT_SEEDS, new Material[]{Material.BEETROOT_SEEDS, Material.CARROT, Material.POTATO, Material.MELON_SEEDS, Material.PUMPKIN_SEEDS});

    public Lucker(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE);
        Lucker.colorLeatherArmor(chestplate, Color.LIME);
        player.getInventory().setChestplate(chestplate);
        player.addPotionEffect(new PotionEffect(PotionEffectType.LUCK, -1, 0, false, false, true));
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        Block block = event.getBlock();
        Material type = block.getType();
        Location loc = block.getLocation();
        switch (type) {
            case COAL_ORE: 
            case IRON_ORE: 
            case GOLD_ORE: 
            case REDSTONE_ORE: 
            case LAPIS_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case COPPER_ORE: 
            case NETHER_QUARTZ_ORE: {
                Collection drops = block.getDrops(player.getInventory().getItemInMainHand());
                for (ItemStack drop : drops) {
                    ItemStack extra = drop.clone();
                    extra.setAmount(1);
                    loc.getWorld().dropItemNaturally(loc, extra);
                }
                break;
            }
        }
        if ((type == Material.OAK_LEAVES || type == Material.DARK_OAK_LEAVES) && this.random.nextDouble() > 0.5) {
            ItemStack apple = new ItemStack(Material.APPLE, 1);
            Location dropLoc = block.getLocation().add(0.5, 0.5, 0.5);
            dropLoc.getWorld().dropItemNaturally(dropLoc, apple);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity dead = event.getEntity();
        Player killer = dead.getKiller();
        if (killer == null) {
            return;
        }
        if (!this.playerCanUseThisKit(killer)) {
            return;
        }
        for (ItemStack drop : event.getDrops().toArray(new ItemStack[0])) {
            ItemStack extra = drop.clone();
            extra.setAmount(2);
            event.getDrops().add(extra);
        }
        switch (dead.getType()) {
            case ZOMBIE: 
            case HUSK: 
            case DROWNED: {
                if (!(Math.random() > 0.4)) break;
                event.getDrops().add(new ItemStack(Material.IRON_INGOT));
                break;
            }
            case SKELETON: {
                if (!(Math.random() > 0.5)) break;
                event.getDrops().add(new ItemStack(Material.BOW));
                break;
            }
            case WITCH: {
                event.getDrops().add(new ItemStack(Material.GLOWSTONE));
                break;
            }
            case PLAYER: {
                ItemStack bad_luck_potions = new ItemStack(Material.SPLASH_POTION);
                PotionMeta meta = (PotionMeta)bad_luck_potions.getItemMeta();
                meta.addCustomEffect(new PotionEffect(PotionEffectType.UNLUCK, 3200, 4), true);
                meta.displayName(Component.text((String)"Splash Potion of Bad Luck").decoration(TextDecoration.ITALIC, false));
                bad_luck_potions.setItemMeta((ItemMeta)meta);
                for (int i = 0; i < 3; ++i) {
                    killer.getInventory().addItem(new ItemStack[]{bad_luck_potions.clone()}).forEach((slot, leftover) -> killer.getWorld().dropItemNaturally(killer.getLocation(), leftover));
                }
                break;
            }
        }
    }

    @EventHandler
    public void onFishCatchEvent(PlayerFishEvent event) {
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        Random rng = new Random();
        if (rng.nextDouble() < 0.1) {
            Material[] fishTypes = new Material[]{Material.COD, Material.SALMON, Material.PUFFERFISH, Material.TROPICAL_FISH};
            for (int i = 0; i < 25; ++i) {
                Material species = fishTypes[rng.nextInt(fishTypes.length)];
                ItemStack fish = new ItemStack(species, 1);
                player.getInventory().addItem(new ItemStack[]{fish}).values().forEach(overflow -> player.getWorld().dropItemNaturally(player.getLocation(), overflow));
            }
        }
    }

    @EventHandler
    private void onCraftItem(CraftItemEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (result.getType() != Material.FISHING_ROD) {
            return;
        }
        ItemStack enchantedRod = result.clone();
        enchantedRod.addUnsafeEnchantment(Enchantment.LURE, 5);
        enchantedRod.addUnsafeEnchantment(Enchantment.LUCK_OF_THE_SEA, 99);
        ItemMeta meta = enchantedRod.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            enchantedRod.setItemMeta(meta);
        }
        event.getInventory().setResult(enchantedRod);
    }

    @EventHandler
    public void onPlayerPlant(final PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack inHand = event.getItem();
        if (inHand == null) {
            return;
        }
        Material seed = inHand.getType();
        if (!SEEDS.contains(seed)) {
            return;
        }
        final Block clicked = event.getClickedBlock();
        if (clicked == null || clicked.getType() != Material.FARMLAND) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Block crop = clicked.getRelative(event.getBlockFace());
                BlockData data = crop.getBlockData();
                if (data instanceof Ageable) {
                    Lucker.this.startFastGrowth(crop);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void startFastGrowth(final Block crop) {
        new BukkitRunnable(this){

            public void run() {
                int max;
                BlockData data = crop.getBlockData();
                if (!(data instanceof Ageable)) {
                    this.cancel();
                    return;
                }
                Ageable ageable = (Ageable)data;
                int age = ageable.getAge();
                if (age < (max = ageable.getMaximumAge())) {
                    ageable.setAge(age + 1);
                    crop.setBlockData((BlockData)ageable, true);
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        event.getEnchantsToAdd().clear();
        int paid = event.getExpLevelCost();
        ItemStack item = event.getItem();
        this.applyLvL30Enchants(item);
        event.setCancelled(true);
        player.setLevel(player.getLevel() - paid);
        player.getOpenInventory().getTopInventory().setItem(0, item);
    }

    private void applyLvL30Enchants(ItemStack item) {
        List pool = Arrays.stream(Enchantment.values()).filter(e -> e.canEnchantItem(item)).filter(e -> !e.isCursed()).collect(Collectors.toList());
        if (pool.isEmpty()) {
            return;
        }
        Random rng = new Random();
        int count = 1 + rng.nextInt(4);
        HashSet<Enchantment> chosen = new HashSet<Enchantment>();
        for (int i = 0; i < count && !pool.isEmpty(); ++i) {
            Enchantment pick = (Enchantment)pool.remove(rng.nextInt(pool.size()));
            chosen.add(pick);
            pool.removeIf(other -> other.conflictsWith(pick));
        }
        for (Enchantment e2 : chosen) {
            int lvl = 1 + rng.nextInt(e2.getMaxLevel());
            item.addUnsafeEnchantment(e2, lvl);
        }
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.AZALEA, "Lucker", "Blessed with extraordinary luck.                (Better chest loot, more luck when fishing, mining, existing,...)", "Light-Green Leather Chestplate", Difficulty.EASY);
    }
}

