/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;

public class Lumberjack
extends AbstractKit {
    public Lumberjack(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setChestplate(Lumberjack.colorLeatherArmor(new ItemStack(Material.LEATHER_CHESTPLATE), Color.fromRGB((int)10820909)));
        player.getInventory().setLeggings(Lumberjack.colorLeatherArmor(new ItemStack(Material.LEATHER_LEGGINGS), Color.fromRGB((int)1728436)));
        player.getInventory().addItem(new ItemStack[]{Lumberjack.enchantItem(new ItemStack(Material.WOODEN_AXE), Enchantment.SHARPNESS, 1)});
    }

    @EventHandler
    private void onBlockBreak(BlockBreakEvent event) {
        if (!Tag.LOGS.isTagged((Keyed)event.getBlock().getType())) {
            return;
        }
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        Location location = event.getBlock().getLocation().add(0.0, 1.0, 0.0);
        this.breakTree(location, event.getPlayer());
    }

    private void breakTree(Location location, Player player) {
        Block block = location.getBlock();
        Material material = block.getType();
        if (!Tag.LOGS.isTagged((Keyed)material) && !Tag.LEAVES.isTagged((Keyed)material)) {
            return;
        }
        if (Tag.LOGS.isTagged((Keyed)material)) {
            ItemStack item = new ItemStack(material);
            player.getInventory().addItem(new ItemStack[]{item});
        }
        block.setType(Material.AIR);
        this.breakTree(location.clone().add(1.0, 0.0, 0.0), player);
        this.breakTree(location.clone().add(-1.0, 0.0, 0.0), player);
        this.breakTree(location.clone().add(0.0, 1.0, 0.0), player);
        this.breakTree(location.clone().add(0.0, 0.0, 1.0), player);
        this.breakTree(location.clone().add(0.0, 0.0, -1.0), player);
    }

    @EventHandler
    private void onCraftItem(CraftItemEvent event) {
        if (!this.playerCanUseThisKit((Player)event.getWhoClicked())) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (!Tag.ITEMS_AXES.isTagged((Keyed)result.getType())) {
            return;
        }
        result.addEnchantment(Enchantment.SHARPNESS, 1);
        event.getInventory().setResult(result);
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.WOODEN_AXE, "Lumberjack", "The lumberjack can fell entire trees with a single axe swing. Every axe he crafts automatically gains Sharpness I.", "Wooden axe, red leather chestplate, blue leather pants, black boots.", Difficulty.EASY);
    }
}

