/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.kits.PlayerState;
import io.github.mal32.endergames.worlds.game.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class Rewind
extends AbstractKit {
    private final int REWIND_SECONDS = 10;
    private final int PLAYER_STATE_INTERVAL_TICKS = 10;
    private final int USE_COOLDOWN_SECONDS = 40;
    private final NamespacedKey rewindKey;
    private BukkitTask task;
    private final HashMap<UUID, ArrayList<PlayerState>> playerStates = new HashMap();

    public Rewind(EnderGames plugin) {
        super(plugin);
        this.rewindKey = new NamespacedKey((Plugin)plugin, "rewind");
    }

    @Override
    public void start(Player player) {
        ItemStack clock = new ItemStack(Material.CLOCK);
        ItemMeta meta = clock.getItemMeta();
        meta.getPersistentDataContainer().set(this.rewindKey, PersistentDataType.BOOLEAN, (Object)true);
        meta.itemName(Component.text((String)"Rewind").color((TextColor)NamedTextColor.GOLD));
        clock.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{clock});
        this.playerStates.put(player.getUniqueId(), new ArrayList());
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.CLOCK, "Rewind", "Can go back 10 seconds in time every 40 seconds.", "Rewind Clock", Difficulty.EASY);
    }

    @Override
    public void enable() {
        super.enable();
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        this.task = scheduler.runTaskTimer((Plugin)this.plugin, this::tick, 10L, 10L);
    }

    @Override
    public void disable() {
        super.disable();
        this.task.cancel();
    }

    private void tick() {
        for (Player player : GameWorld.getPlayersInGame()) {
            if (!this.playerCanUseThisKit(player)) continue;
            PlayerState playerState = new PlayerState(player.getLocation(), player.getHealth(), player.getActivePotionEffects());
            ArrayList<PlayerState> stateRecords = this.playerStates.get(player.getUniqueId());
            stateRecords.addFirst(playerState);
            if (stateRecords.size() < 20) continue;
            stateRecords.removeLast();
        }
    }

    @EventHandler
    private void onClockClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.CLOCK) {
            return;
        }
        if (!item.getItemMeta().getPersistentDataContainer().has(this.rewindKey, PersistentDataType.BOOLEAN)) {
            return;
        }
        if (player.hasCooldown(Material.CLOCK)) {
            return;
        }
        player.setCooldown(Material.CLOCK, 800);
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
        Enderman enderman = (Enderman)player.getWorld().spawn(player.getLocation(), Enderman.class);
        enderman.setAI(false);
        enderman.setInvulnerable(true);
        enderman.setInvisible(true);
        this.rewindStart(player, enderman);
        int ANIMATION_SPEED_TICKS = 3;
        ArrayList<PlayerState> stateRecords = this.playerStates.get(player.getUniqueId());
        int i = 0;
        for (PlayerState playerState : stateRecords) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.rewindTick(player, playerState, enderman), (long)i * 3L);
            ++i;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.rewindEnd(player, (PlayerState)stateRecords.getLast(), enderman), (long)stateRecords.size() * 3L);
    }

    private void rewindStart(Player player, Enderman enderman) {
        player.setGameMode(GameMode.SPECTATOR);
        player.setSpectatorTarget((Entity)enderman);
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
    }

    private void rewindTick(Player player, PlayerState playerState, Enderman enderman) {
        enderman.teleport(playerState.location());
        player.getLocation().getWorld().spawnParticle(Particle.END_ROD, player.getLocation().clone().add(0.0, 1.0, 0.0), 3, 0.2, 0.2, 0.2, 0.0);
    }

    private void rewindEnd(Player player, PlayerState lastState, Enderman enderman) {
        player.teleport(lastState.location());
        player.setGameMode(GameMode.SURVIVAL);
        player.setHealth(lastState.health());
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        for (PotionEffect effect : lastState.potionEffects()) {
            player.addPotionEffect(effect);
        }
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
        enderman.remove();
    }
}

