/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class Slime
extends AbstractKit {
    public Slime(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void start(Player player) {
        player.getInventory().setChestplate(Slime.colorLeatherArmor(new ItemStack(Material.LEATHER_CHESTPLATE), Color.fromRGB((int)3144049)));
        player.getInventory().setBoots(Slime.colorLeatherArmor(new ItemStack(Material.LEATHER_BOOTS), Color.fromRGB((int)3144049)));
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SLIME_BALL, 20)});
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, -1, 1, true, false));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || !this.playerCanUseThisKit(player = (Player)entity)) {
            return;
        }
        if (event.getDamager() instanceof EnderPearl) {
            return;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        Random random = new Random();
        int loops = random.nextInt(3) + 1;
        for (int x = 0; x < loops; ++x) {
            Location editLoc = location.clone();
            editLoc.add(1.0 - Math.random() * 2.0, 0.1, 1.0 - Math.random() * 2.0);
            if (world.getBlockAt(editLoc).getType() != Material.AIR && world.getBlockAt(editLoc).getType() != Material.WATER) continue;
            org.bukkit.entity.Slime slime = (org.bukkit.entity.Slime)world.spawnEntity(editLoc, EntityType.SLIME);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (slime.isValid()) {
                    slime.remove();
                }
            }, 80L);
            slime.setLootTable(LootTables.ENDERMITE.getLootTable());
            slime.setSize(0);
            slime.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "slimekitslime"), PersistentDataType.INTEGER, (Object)1);
        }
    }

    @EventHandler
    public void onSlimeDeath(EntityDeathEvent event) {
        org.bukkit.entity.Slime slime;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof org.bukkit.entity.Slime && (slime = (org.bukkit.entity.Slime)livingEntity).getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "slimekitslime"), PersistentDataType.INTEGER)) {
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    @EventHandler
    public void onSlimeballClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.playerCanUseThisKit(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.SLIME_BALL && (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            this.throwSlimeball(player);
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
        }
    }

    public void throwSlimeball(Player player) {
        Snowball snowball = (Snowball)player.launchProjectile(Snowball.class);
        snowball.setItem(new ItemStack(Material.SLIME_BALL));
        snowball.setShooter((ProjectileSource)player);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Snowball)) {
            return;
        }
        Entity entity = event.getHitEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player hitEntity = (Player)entity;
        if (hitEntity.isBlocking()) {
            return;
        }
        if (hitEntity.getPotionEffect(PotionEffectType.SLOWNESS) != null) {
            int amplifier = hitEntity.getPotionEffect(PotionEffectType.SLOWNESS).getAmplifier();
            if (amplifier < 2) {
                ++amplifier;
            }
            hitEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 140, amplifier, true, false));
        }
        hitEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 140, 0, true, false));
        Location location = hitEntity.getLocation();
        location.getWorld().playSound(location, Sound.ENTITY_SLIME_HURT, 1.0f, 1.0f);
        location.getWorld().spawnParticle(Particle.ITEM_SLIME, location.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        Player shooterPlayer = (Player)event.getEntity().getShooter();
        if (shooterPlayer != null) {
            Location shooterLocation = shooterPlayer.getLocation();
            shooterLocation.getWorld().playSound(shooterLocation, Sound.ENTITY_SLIME_SQUISH_SMALL, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        double SLIMEBALL_PROBABILITY = 0.15;
        if (Math.random() > 0.15) {
            return;
        }
        ItemStack slimeball = new ItemStack(Material.SLIME_BALL, 1);
        event.getPlayer().getInventory().addItem(new ItemStack[]{slimeball});
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.SLIME_BALL, "Slime", "Occasionally gains slimeballs when jumping, which can be thrown to slow enemies. Spawns small slimes when hit. Permanent Jump Boost II.", "10 slimeballs, green leather chestplate & boots", Difficulty.MEDIUM);
    }
}

