/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.kits;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.Difficulty;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.game.game.PotionEffectsStacking;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;

public class Voodoo
extends AbstractKit {
    private BukkitTask voodooTask;

    public Voodoo(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        super.enable();
        this.voodooTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::witherTask, 20L, 20L);
    }

    @Override
    public void disable() {
        super.disable();
        this.voodooTask.cancel();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.playerCanUseThisKit(event.getPlayer())) {
            return;
        }
        Player player = event.getPlayer();
        player.getInventory().clear();
        player.setLevel(0);
    }

    @EventHandler
    public void regenerateOnBowHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        if (!this.playerCanUseThisKit(shooter)) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        PotionEffectsStacking.addPotionEffect(shooter, new PotionEffect(PotionEffectType.REGENERATION, 1, 5, true, false, false));
    }

    @EventHandler
    public void healthBoostOnEnemyLow(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!this.playerCanUseThisKit(attacker)) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player victim = (Player)entity2;
        AttributeInstance attribute = victim.getAttribute(Attribute.MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        if (victim.getHealth() <= attribute.getValue() * 0.4) {
            PotionEffectsStacking.addPotionEffect(attacker, new PotionEffect(PotionEffectType.ABSORPTION, 1200, 0, true));
        }
    }

    private void witherTask() {
        for (Player player : GameWorld.getPlayersInGame()) {
            if (!this.playerCanUseThisKit(player)) continue;
            for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
                if (!(entity instanceof Player)) continue;
                Player target = (Player)entity;
                target.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 40, 0, true, false, false));
            }
        }
    }

    @Override
    public void start(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.addItem(new ItemStack[]{new ItemStack(Material.BOW)});
        playerInventory.addItem(new ItemStack[]{new ItemStack(Material.ARROW, 10)});
        playerInventory.setBoots(new ItemStack(Material.LEATHER_BOOTS));
    }

    @Override
    public KitDescription getDescription() {
        return new KitDescription(Material.SCULK, "Voodoo", "Doesn't drop items on death. Hitting players with arrows regenerates health. Making an enemy low on health gives you extra hearts for a short time. Nearby players get black hearts.", "Bow with 10 arrows. Leather boots.", Difficulty.MEDIUM);
    }

    @EventHandler
    public void cancelVoodooWitherDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.WITHER) {
            return;
        }
        PotionEffect effect = player.getActivePotionEffects().stream().filter(eff -> eff.getType() == PotionEffectType.WITHER).findFirst().orElse(null);
        if (effect != null && !effect.hasIcon()) {
            event.setCancelled(true);
        }
    }
}

