/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.AbstractWorld;
import io.github.mal32.endergames.worlds.game.AbstractPhase;
import io.github.mal32.endergames.worlds.game.EndPhase;
import io.github.mal32.endergames.worlds.game.LoadPhase;
import io.github.mal32.endergames.worlds.game.StartPhase;
import io.github.mal32.endergames.worlds.game.WorldManager;
import io.github.mal32.endergames.worlds.game.game.GamePhase;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;

public class GameWorld
extends AbstractWorld {
    private final WorldManager worldManager;
    private AbstractPhase currentPhase;

    public GameWorld(EnderGames plugin) {
        super(plugin);
        this.worldManager = new WorldManager(plugin);
        this.currentPhase = new LoadPhase(plugin, this, this.worldManager.getSpawnLocation());
    }

    public static boolean playerIsInGame(Player player) {
        return EnderGames.playerIsInGameWorld(player) && player.getGameMode() != GameMode.SPECTATOR;
    }

    public static Player[] getPlayersInGame() {
        return (Player[])Bukkit.getOnlinePlayers().stream().filter(GameWorld::playerIsInGame).toArray(Player[]::new);
    }

    public static Player[] getPlayersInGameWorld() {
        return (Player[])Bukkit.getOnlinePlayers().stream().filter(EnderGames::playerIsInGameWorld).toArray(Player[]::new);
    }

    public void startGame() {
        if (!(this.currentPhase instanceof LoadPhase)) {
            return;
        }
        this.nextPhase();
    }

    public void nextPhase() {
        this.currentPhase.disable();
        Location spawnLocation = this.worldManager.getSpawnLocation();
        if (this.currentPhase instanceof LoadPhase) {
            this.currentPhase = new StartPhase(this.plugin, this, spawnLocation);
        } else if (this.currentPhase instanceof StartPhase) {
            this.currentPhase = new GamePhase(this.plugin, this, spawnLocation);
        } else if (this.currentPhase instanceof GamePhase) {
            this.currentPhase = new EndPhase(this.plugin, this, spawnLocation);
        } else if (this.currentPhase instanceof EndPhase) {
            for (Player p : GameWorld.getPlayersInGameWorld()) {
                this.plugin.teleportPlayerToLobby(p);
            }
            this.worldManager.findAndSaveNewSpawnLocation();
            this.plugin.getComponentLogger().info("Spawn location: " + String.valueOf(spawnLocation));
            this.currentPhase = new LoadPhase(this.plugin, this, spawnLocation);
        }
    }

    @Override
    public void initPlayer(Player player) {
        player.teleport(this.worldManager.getSpawnLocation().clone().add(0.0, 5.0, 0.0));
        if (this.currentPhase instanceof StartPhase) {
            player.setGameMode(GameMode.ADVENTURE);
        } else {
            player.setGameMode(GameMode.SPECTATOR);
        }
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!EnderGames.playerIsInGameWorld(player)) {
            return;
        }
        if (GameWorld.playerIsInGame(player)) {
            return;
        }
        event.setCancelled(true);
    }
}

