/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.AbstractPhase;
import io.github.mal32.endergames.worlds.game.GameWorld;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.BlockVector;

public class LoadPhase
extends AbstractPhase {
    final int loadDelayIncrease = 5;
    private final ArrayList<BukkitTask> loadTasks = new ArrayList();
    int loadDelayTicks = 0;

    public LoadPhase(EnderGames plugin, GameWorld manager, Location spawnLocation) {
        super(plugin, manager, spawnLocation);
        this.placeSpawnPlatform();
        BukkitTask startLoadTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::loadSpawnChunks, 100L);
        this.loadTasks.add(startLoadTask);
    }

    public void placeSpawnPlatform() {
        StructureManager manager = Bukkit.getServer().getStructureManager();
        Structure structure = manager.loadStructure(new NamespacedKey("enga", "spawn_platform"));
        BlockVector structureSize = structure.getSize();
        double posX = (double)this.spawnLocation.getBlockX() - (double)structureSize.getBlockX() / 2.0 + 1.0;
        double posZ = (double)this.spawnLocation.getBlockZ() - (double)structureSize.getBlockZ() / 2.0;
        Location location = new Location(this.spawnLocation.getWorld(), posX, this.spawnLocation.getY(), posZ);
        structure.place(location, true, StructureRotation.NONE, Mirror.NONE, 0, 1.0f, new Random());
    }

    private void loadSpawnChunks() {
        int loadRadius = 8;
        Location location = this.spawnLocation.clone();
        int invert = 1;
        for (int i = 0; i < 8; ++i) {
            int k;
            for (k = 0; k < i; ++k) {
                location.add((double)(invert * 16), 0.0, 0.0);
                this.scheduleChunkLoad(location.clone());
            }
            for (k = 0; k < i; ++k) {
                location.add(0.0, 0.0, (double)(invert * 16));
                this.scheduleChunkLoad(location.clone());
            }
            invert *= -1;
        }
    }

    private void scheduleChunkLoad(Location location) {
        BukkitTask chunkLoadTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> location.getWorld().getChunkAt(location).load(true), (long)this.loadDelayTicks);
        this.loadTasks.add(chunkLoadTask);
        this.loadDelayTicks += 5;
    }

    @Override
    public void disable() {
        super.disable();
        for (BukkitTask task : this.loadTasks) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
    }
}

