/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.KitDescription;
import io.github.mal32.endergames.worlds.game.AbstractPhase;
import io.github.mal32.endergames.worlds.game.GameWorld;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.BlockVector;

public class StartPhase
extends AbstractPhase {
    public StartPhase(EnderGames plugin, GameWorld manager, Location spawnLocation) {
        super(plugin, manager, spawnLocation);
        World world = spawnLocation.getWorld();
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.getPersistentDataContainer().set(new NamespacedKey("endergames", "world"), PersistentDataType.STRING, (Object)"game");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, this::distributePlayers, 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, this::showPlayersKitInfo, 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, this::runCountdown, 25L);
        world.setTime(0L);
        world.getWorldBorder().setSize(600.0);
    }

    public void distributePlayers() {
        int playerindex = 0;
        int totalPlayers = Bukkit.getServer().getOnlinePlayers().size();
        for (Player player : GameWorld.getPlayersInGameWorld()) {
            player.setGameMode(GameMode.ADVENTURE);
            player.getInventory().clear();
            this.teleportToPlayerSpawns(player, playerindex, totalPlayers);
            ++playerindex;
        }
    }

    private void showPlayersKitInfo() {
        List<AbstractKit> kits = AbstractKit.getKits(this.plugin);
        for (Player player : GameWorld.getPlayersInGameWorld()) {
            String playerKit = (String)player.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "kit"), PersistentDataType.STRING);
            for (AbstractKit kit : kits) {
                if (!Objects.equals(kit.getNameLowercase(), playerKit)) continue;
                KitDescription kitDescription = kit.getDescription();
                BuildableComponent nameMessage = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"\nYou are playing as ", (TextColor)NamedTextColor.YELLOW))).append(((TextComponent)Component.text((String)kitDescription.name()).color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD))).build();
                BuildableComponent abilitiesMessage = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(((TextComponent)Component.text((String)"\nAbilities\n").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD))).append(Component.text((String)(kitDescription.abilities() + "\n")).color((TextColor)NamedTextColor.YELLOW))).build();
                player.sendMessage((Component)nameMessage);
                player.sendMessage((Component)abilitiesMessage);
            }
        }
    }

    @Override
    public void disable() {
        super.disable();
        for (Player player : GameWorld.getPlayersInGame()) {
            player.clearActivePotionEffects();
        }
    }

    private void runCountdown() {
        Integer[] titleTimes;
        Integer[] integerArray;
        int totalCountdownTimeSeconds;
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        int n = totalCountdownTimeSeconds = EnderGames.isInDebugMode() ? 5 : 20;
        if (EnderGames.isInDebugMode()) {
            Integer[] integerArray2 = new Integer[5];
            integerArray2[0] = 1;
            integerArray2[1] = 2;
            integerArray2[2] = 3;
            integerArray2[3] = 4;
            integerArray = integerArray2;
            integerArray2[4] = 5;
        } else {
            Integer[] integerArray3 = new Integer[8];
            integerArray3[0] = 1;
            integerArray3[1] = 2;
            integerArray3[2] = 3;
            integerArray3[3] = 4;
            integerArray3[4] = 5;
            integerArray3[5] = 10;
            integerArray3[6] = 15;
            integerArray = integerArray3;
            integerArray3[7] = 20;
        }
        for (Integer titleTime : titleTimes = integerArray) {
            int scheduleTicks = (totalCountdownTimeSeconds - titleTime) * 20;
            scheduler.runTaskLater((Plugin)this.plugin, () -> {
                for (Player player : GameWorld.getPlayersInGame()) {
                    this.showTitleToPlayerWithSound(player, Component.text((String)("" + titleTime)).color((TextColor)NamedTextColor.YELLOW), Sound.BLOCK_NOTE_BLOCK_HARP);
                }
            }, (long)scheduleTicks);
        }
        scheduler.runTaskLater((Plugin)this.plugin, () -> {
            for (Player player : GameWorld.getPlayersInGame()) {
                this.showTitleToPlayerWithSound(player, Component.text((String)"Start").color((TextColor)NamedTextColor.GOLD), Sound.BLOCK_NOTE_BLOCK_FLUTE);
            }
        }, (long)(totalCountdownTimeSeconds * 20));
        scheduler.runTaskLater((Plugin)this.plugin, this.manager::nextPhase, (long)(totalCountdownTimeSeconds * 20));
    }

    private void showTitleToPlayerWithSound(Player player, Component text, Sound sound) {
        Title.Times titleTime = Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(250L));
        Title title = Title.title((Component)text, (Component)Component.text((String)""), (Title.Times)titleTime);
        player.showTitle(title);
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    private void teleportToPlayerSpawns(Player player, int playerIndex, int totalPlayers) {
        if (totalPlayers == 0) {
            return;
        }
        List<BlockVector> offsets = this.makeSpawnOffsets();
        int offsetIndex = playerIndex * offsets.size() / totalPlayers;
        BlockVector offset = offsets.get(offsetIndex);
        World world = this.spawnLocation.getWorld();
        double x = this.spawnLocation.getX() + offset.getX();
        double y = this.spawnLocation.getY();
        double z = this.spawnLocation.getZ() + offset.getZ();
        Location dest = new Location(world, x, y + 1.5, z);
        double dx = this.spawnLocation.getX() - x;
        double dz = this.spawnLocation.getZ() - z;
        float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        dest.setYaw(yaw);
        dest.setPitch(0.0f);
        player.teleport(dest);
        this.plugin.getLogger().info("Teleporting to " + String.valueOf(dest));
    }

    public List<BlockVector> makeSpawnOffsets() {
        return List.of(new BlockVector(0.5, 0.0, -9.5), new BlockVector(2.5, 0.0, -9.5), new BlockVector(4.5, 0.0, -8.5), new BlockVector(6.5, 0.0, -6.5), new BlockVector(8.5, 0.0, -4.5), new BlockVector(9.5, 0.0, -2.5), new BlockVector(9.5, 0.0, 0.5), new BlockVector(9.5, 0.0, 1.5), new BlockVector(8.5, 0.0, 3.5), new BlockVector(6.5, 0.0, 5.5), new BlockVector(4.5, 0.0, 7.5), new BlockVector(2.5, 0.0, 8.5), new BlockVector(0.5, 0.0, 8.5), new BlockVector(-1.5, 0.0, 8.5), new BlockVector(-3.5, 0.0, 7.5), new BlockVector(-5.5, 0.0, 5.5), new BlockVector(-7.5, 0.0, 3.5), new BlockVector(-8.5, 0.0, 1.5), new BlockVector(-8.5, 0.0, 0.0), new BlockVector(-8.5, 0.0, -2.5), new BlockVector(-7.5, 0.0, -4.5), new BlockVector(-5.5, 0.0, -6.5), new BlockVector(-3.5, 0.0, -8.5), new BlockVector(-1.5, 0.0, -9.5));
    }

    @EventHandler
    private void onPlayerMove(PlayerMoveEvent event) {
        if (!GameWorld.playerIsInGame(event.getPlayer())) {
            return;
        }
        Location startLocation = event.getFrom();
        event.getTo().setX(startLocation.getX());
        event.getTo().setZ(startLocation.getZ());
    }
}

